/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.qualityIndicator.R2;
import jmetal.util.PseudoRandom;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;

public class R2Archive
extends Archive {
    private int maxSize_;
    private int objectives_;
    private Comparator dominance_;
    private Comparator equals_;
    private Comparator crowdingDistance_;
    private R2 r2Indicator_;

    public R2Archive(int maxSize) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = 2;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.crowdingDistance_ = new CrowdingDistanceComparator();
        this.r2Indicator_ = new R2();
    }

    public R2Archive(int maxSize, int numberOfObjectives, String file) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = numberOfObjectives;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.crowdingDistance_ = new CrowdingDistanceComparator();
        this.r2Indicator_ = new R2(numberOfObjectives, file);
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            int indexWorst = this.r2Indicator_.getWorst(this);
            this.remove(indexWorst);
        }
        return true;
    }

    public Solution getSolution() {
        double aux2;
        int index1 = PseudoRandom.randInt(0, this.size() - 1);
        int index2 = PseudoRandom.randInt(0, this.size() - 1);
        double aux1 = this.r2Indicator_.R2Without(this, index1);
        if (aux1 > (aux2 = this.r2Indicator_.R2Without(this, index2))) {
            return this.get(index1);
        }
        return this.get(index2);
    }
}

