/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.util.Spea2Fitness;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;
import jmetal.util.comparators.FitnessComparator;

public class SPEA2DensityArchive
extends Archive {
    private int maxSize_;
    private Comparator dominance_;
    private Comparator fitnessComparator_;
    private Comparator equals_;

    public SPEA2DensityArchive(int maxSize) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.fitnessComparator_ = new FitnessComparator();
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            new Spea2Fitness(this).fitnessAssign();
            this.remove(this.indexWorst(this.fitnessComparator_));
        }
        return true;
    }
}

