/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.qualityIndicator.fastHypervolume.wfg.Point;
import jmetal.qualityIndicator.fastHypervolume.wfg.WFGHV;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.Distance;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;

public class WFGHypervolumeArchive
extends Archive {
    private int maxSize_;
    private int objectives_;
    private Comparator dominance_;
    private Comparator equals_;
    private Distance distance_;
    private MetricsUtil utils_;
    private double offset_;
    private Comparator crowdingDistance_;
    private WFGHV wfg = null;

    public WFGHypervolumeArchive(int maxSize, int numberOfObjectives) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = numberOfObjectives;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.distance_ = new Distance();
        this.utils_ = new MetricsUtil();
        this.offset_ = 100.0;
        this.crowdingDistance_ = new CrowdingDistanceComparator();
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            double[] vector = new double[this.objectives_];
            for (int o = 0; o < this.objectives_; ++o) {
                vector[0] = this.get(0).getObjective(o);
            }
            for (int j = 1; j < this.size(); ++j) {
                for (int o = 0; o < this.objectives_; ++o) {
                    if (!(this.get(j).getObjective(o) > vector[o])) continue;
                    vector[o] = 1.0;
                }
            }
            Point p = new Point(vector);
            this.wfg = new WFGHV(this.objectives_, this.size(), p);
            this.remove(this.wfg.getLessContributorHV(this));
        }
        return true;
    }

    public void computeHVContribution() {
        double[] vector = new double[this.objectives_];
        for (int o = 0; o < this.objectives_; ++o) {
            vector[0] = this.get(0).getObjective(o);
        }
        for (int j = 1; j < this.size(); ++j) {
            for (int o = 0; o < this.objectives_; ++o) {
                if (!(this.get(j).getObjective(o) > vector[o])) continue;
                vector[o] = 1.0;
            }
        }
        Point p = new Point(vector);
        this.wfg = new WFGHV(this.objectives_, this.size(), p);
        this.wfg.getLessContributorHV(this);
    }
}

