/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.avl;

import java.util.Comparator;
import jmetal.util.avl.AvlNode;

public class AvlTree<T> {
    AvlNode<T> top_ = null;
    Comparator comparator_;

    public AvlTree(Comparator comparator_) {
        this.comparator_ = comparator_;
    }

    public void insert(T item) {
        AvlNode<T> node = new AvlNode<T>(item);
        this.insertAvlNode(node);
    }

    public void insertAvlNode(AvlNode node) {
        if (this.AvlIsEmpty()) {
            this.insertTop(node);
        } else {
            Object closestNode = null;
            int result = this.searchClosestNode(node);
            switch (result) {
                case -1: {
                    this.insertNodeLeft(node);
                    break;
                }
                case 1: {
                    this.insertNodeRight(node);
                    break;
                }
            }
        }
    }

    public AvlNode<T> search(T item) {
        AvlNode<T> node = new AvlNode<T>(item);
        return this.searchNode(node);
    }

    public AvlNode<T> searchNode(AvlNode<T> targetNode) {
        AvlNode result = null;
        AvlNode currentNode = this.top_;
        if (this.top_ == null) {
            result = null;
        } else {
            boolean searchFinished = false;
            while (!searchFinished) {
                int comparison = this.compareNodes(targetNode, currentNode);
                if (comparison < 0) {
                    if (currentNode.getLeft() != null) {
                        currentNode = currentNode.getLeft();
                        continue;
                    }
                    searchFinished = true;
                    result = null;
                    continue;
                }
                if (comparison > 0) {
                    if (currentNode.getRight() != null) {
                        currentNode = currentNode.getRight();
                        continue;
                    }
                    searchFinished = true;
                    result = null;
                    continue;
                }
                searchFinished = true;
                result = currentNode;
            }
        }
        return result;
    }

    public void delete(T item) {
        this.deleteNode(new AvlNode<T>(item));
    }

    public void deleteNode(AvlNode<T> node) {
        AvlNode<T> nodeFound = this.searchNode(node);
        if (nodeFound != null) {
            if (nodeFound.isLeaf()) {
                this.deleteLeafNode(nodeFound);
            } else if (nodeFound.hasOnlyALeftChild()) {
                this.deleteNodeWithALeftChild(nodeFound);
            } else if (nodeFound.hasOnlyARightChild()) {
                this.deleteNodeWithARightChild(nodeFound);
            } else {
                AvlNode<T> successor = this.findSuccessor(nodeFound);
                T tmp = successor.getItem();
                successor.setItem(nodeFound.getItem());
                nodeFound.setItem(tmp);
                if (successor.isLeaf()) {
                    this.deleteLeafNode(successor);
                } else if (successor.hasOnlyALeftChild()) {
                    this.deleteNodeWithALeftChild(successor);
                } else if (successor.hasOnlyARightChild()) {
                    this.deleteNodeWithARightChild(successor);
                }
            }
        }
    }

    public void deleteLeafNode(AvlNode<T> node) {
        if (!node.hasParent()) {
            this.top_ = null;
        } else {
            if (node.getParent().getLeft() == node) {
                node.getParent().setLeft(null);
            } else {
                node.getParent().setRight(null);
            }
            node.getParent().updateHeight();
            this.rebalance(node.getParent());
        }
    }

    public void deleteNodeWithALeftChild(AvlNode<T> node) {
        node.setItem(node.getLeft().getItem());
        node.setLeft(null);
        node.updateHeight();
        this.rebalance(node);
    }

    public void deleteNodeWithARightChild(AvlNode<T> node) {
        node.setItem(node.getRight().getItem());
        node.setRight(null);
        node.updateHeight();
        this.rebalance(node);
    }

    public int searchClosestNode(AvlNode node) {
        int result = 0;
        AvlNode currentNode = this.top_;
        if (this.top_ == null) {
            result = 0;
        } else {
            boolean notFound = true;
            while (notFound) {
                int comparison = this.compareNodes(node, currentNode);
                if (comparison < 0) {
                    if (currentNode.hasLeft()) {
                        currentNode = currentNode.getLeft();
                        continue;
                    }
                    notFound = false;
                    node.setClosestNode_(currentNode);
                    result = -1;
                    continue;
                }
                if (comparison > 0) {
                    if (currentNode.hasRight()) {
                        currentNode = currentNode.getRight();
                        continue;
                    }
                    notFound = false;
                    node.setClosestNode_(currentNode);
                    result = 1;
                    continue;
                }
                notFound = false;
                node.setClosestNode_(currentNode);
                result = 0;
            }
        }
        return result;
    }

    public AvlNode<T> findSuccessor(AvlNode<T> node) {
        AvlNode result = null;
        if (node.hasRight()) {
            AvlNode tmp = node.getRight();
            while (tmp.hasLeft()) {
                tmp = tmp.getLeft();
            }
            result = tmp;
        } else {
            while (node.hasParent() && node.getParent().getRight() == node) {
                node = node.getParent();
            }
            result = node.getParent();
        }
        return result;
    }

    public void insertNodeLeft(AvlNode<T> node) {
        node.getClosestNode().setLeft(node);
        node.setParent(node.getClosestNode());
        this.rebalance(node);
    }

    public void insertNodeRight(AvlNode<T> node) {
        node.getClosestNode().setRight(node);
        node.setParent(node.getClosestNode());
        this.rebalance(node);
    }

    public int compareNodes(AvlNode node1, AvlNode node2) {
        return this.comparator_.compare(node1.getItem(), node2.getItem());
    }

    public void rebalance(AvlNode<T> node) {
        AvlNode currentNode = node;
        boolean notFinished = true;
        while (notFinished) {
            if (this.getBalance(currentNode) == -2) {
                if (this.height(currentNode.getLeft().getLeft()) >= this.height(currentNode.getLeft().getRight())) {
                    this.leftRotation(currentNode);
                } else {
                    this.doubleLeftRotation(currentNode);
                }
            }
            if (this.getBalance(currentNode) == 2) {
                if (this.height(currentNode.getRight().getRight()) >= this.height(currentNode.getRight().getLeft())) {
                    this.rightRotation(currentNode);
                } else {
                    this.doubleRightRotation(currentNode);
                }
            }
            if (currentNode.hasParent()) {
                currentNode.getParent().updateHeight();
                currentNode = currentNode.getParent();
                continue;
            }
            this.setTop(currentNode);
            notFinished = false;
        }
    }

    public void leftRotation(AvlNode<T> node) {
        AvlNode leftNode = node.getLeft();
        if (node.hasParent()) {
            leftNode.setParent(node.getParent());
            if (node.getParent().getLeft() == node) {
                node.getParent().setLeft(leftNode);
            } else {
                node.getParent().setRight(leftNode);
            }
        } else {
            this.setTop(leftNode);
        }
        node.setLeft(node.getLeft().getRight());
        leftNode.setRight(node);
        node.setParent(leftNode);
        node.updateHeight();
        leftNode.updateHeight();
    }

    public void rightRotation(AvlNode<T> node) {
        AvlNode rightNode = node.getRight();
        if (node.hasParent()) {
            rightNode.setParent(node.getParent());
            if (node.getParent().getRight() == node) {
                node.getParent().setRight(rightNode);
            } else {
                node.getParent().setLeft(rightNode);
            }
        } else {
            this.setTop(rightNode);
        }
        node.setRight(node.getRight().getLeft());
        rightNode.setLeft(node);
        node.setParent(rightNode);
        node.updateHeight();
        rightNode.updateHeight();
    }

    public void doubleLeftRotation(AvlNode<T> node) {
        AvlNode leftNode = node.getLeft();
        this.rightRotation(leftNode);
        this.leftRotation(node);
    }

    public void doubleRightRotation(AvlNode<T> node) {
        AvlNode rightNode = node.getRight();
        this.leftRotation(rightNode);
        this.rightRotation(node);
    }

    public int getBalance(AvlNode<T> node) {
        int leftHeight = 0;
        int rightHeight = 0;
        leftHeight = node.hasLeft() ? node.getLeft().getHeight() : -1;
        rightHeight = node.hasRight() ? node.getRight().getHeight() : -1;
        return rightHeight - leftHeight;
    }

    public boolean AvlIsEmpty() {
        return this.top_ == null;
    }

    public void insertTop(AvlNode node) {
        this.top_ = node;
    }

    public AvlNode<T> getTop() {
        return this.top_;
    }

    public void setTop(AvlNode<T> top) {
        this.top_ = top;
        this.top_.setParent(null);
    }

    public int height(AvlNode<T> node) {
        int result = 0;
        result = node == null ? -1 : node.getHeight();
        return result;
    }

    public String toString() {
        String result = "";
        result = this.inOrder(this.top_);
        return result;
    }

    private String inOrder(AvlNode<T> node) {
        if (node == null) {
            return "";
        }
        String result = "";
        result = " | " + node.getItem();
        result = result + this.inOrder(node.getLeft());
        result = result + this.inOrder(node.getRight());
        return result;
    }
}

