/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.comparators;

import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.comparators.IConstraintViolationComparator;

public class ViolationThresholdComparator
implements IConstraintViolationComparator {
    private double threshold_ = 0.0;

    @Override
    public int compare(Object o1, Object o2) {
        double overall1 = (double)((Solution)o1).getNumberOfViolatedConstraint() * ((Solution)o1).getOverallConstraintViolation();
        double overall2 = (double)((Solution)o2).getNumberOfViolatedConstraint() * ((Solution)o2).getOverallConstraintViolation();
        if (overall1 < 0.0 && overall2 < 0.0) {
            if (overall1 > overall2) {
                return -1;
            }
            if (overall2 > overall1) {
                return 1;
            }
            return 0;
        }
        if (overall1 == 0.0 && overall2 < 0.0) {
            return -1;
        }
        if (overall1 < 0.0 && overall2 == 0.0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean needToCompare(Solution o1, Solution o2) {
        double overall1 = Math.abs((double)o1.getNumberOfViolatedConstraint() * o1.getOverallConstraintViolation());
        double overall2 = Math.abs((double)o2.getNumberOfViolatedConstraint() * o2.getOverallConstraintViolation());
        boolean needToCompare = overall1 > this.threshold_ || overall2 > this.threshold_;
        return needToCompare;
    }

    public double feasibilityRatio(SolutionSet solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (!(solutionSet.get(i).getOverallConstraintViolation() < 0.0)) continue;
            aux += 1.0;
        }
        return aux / (double)solutionSet.size();
    }

    public double meanOveralViolation(SolutionSet solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            aux += Math.abs((double)solutionSet.get(i).getNumberOfViolatedConstraint() * solutionSet.get(i).getOverallConstraintViolation());
        }
        return aux / (double)solutionSet.size();
    }

    public void updateThreshold(SolutionSet set) {
        this.threshold_ = this.feasibilityRatio(set) * this.meanOveralViolation(set);
    }
}

