/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.offspring;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Operator;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.SelectionFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.Offspring;

public class DifferentialEvolutionOffspringPolynomial
extends Offspring {
    private double mutationProbability_ = 0.0;
    double crossoverProbability_ = 0.9;
    private double distributionIndexForMutation_ = 20.0;
    double distributionIndexForCrossover_ = 20.0;
    private Operator mutation_;
    private Operator selection_;

    private DifferentialEvolutionOffspringPolynomial(double mutationProbability, double distributionIndexForMutation) throws JMException {
        this.mutationProbability_ = mutationProbability;
        this.distributionIndexForMutation_ = distributionIndexForMutation;
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.distributionIndexForMutation_);
        this.mutation_ = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        this.selection_ = SelectionFactory.getSelectionOperator("BinaryTournament", null);
        this.id_ = "Polynomial";
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            offSpring = new Solution((Solution)this.selection_.execute(solutionSet));
            this.mutation_.execute(offSpring);
        }
        catch (JMException ex) {
            Logger.getLogger(DifferentialEvolutionOffspringPolynomial.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet, SolutionSet archive) {
        Object parents = null;
        Solution offSpring = null;
        try {
            parents[0] = (Solution)this.selection_.execute(solutionSet);
            parents[1] = archive.size() > 0 ? (Solution)this.selection_.execute(archive) : (Solution)this.selection_.execute(solutionSet);
            offSpring = new Solution(new Solution((Solution)this.selection_.execute(solutionSet)));
            this.mutation_.execute(offSpring);
        }
        catch (JMException ex) {
            Logger.getLogger(DifferentialEvolutionOffspringPolynomial.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    public Solution getOffspring(Solution solution) {
        Solution res = new Solution(solution);
        try {
            this.mutation_.execute(res);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        return res;
    }
}

