/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.offspring;

import java.util.HashMap;
import jmetal.core.Operator;
import jmetal.core.Solution;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.SelectionFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.Offspring;

public class NonUniformMutationOffspring
extends Offspring {
    public Operator mutation_;
    private Operator selection_;
    private double mutationProbatility_;
    private double perturbation_;
    private int maxIterations_;

    public NonUniformMutationOffspring(double mutationProbability, double perturbation, int maxIterations) throws JMException {
        HashMap<String, Number> parameters = new HashMap<String, Number>();
        this.mutationProbatility_ = mutationProbability;
        parameters.put("probability", this.mutationProbatility_);
        this.perturbation_ = perturbation;
        parameters.put("perturbation", this.perturbation_);
        this.maxIterations_ = maxIterations;
        parameters.put("maxIterations", this.maxIterations_);
        this.mutation_ = MutationFactory.getMutationOperator("NonUniformMutation", parameters);
        this.selection_ = SelectionFactory.getSelectionOperator("BinaryTournament", null);
        this.id_ = "NonUniformMutation";
    }

    public Solution getOffspring(Solution solution) {
        Solution res = new Solution(solution);
        try {
            this.mutation_.execute(res);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String configuration() {
        String result = "-----\n";
        result = result + "Operator: " + this.id_ + "\n";
        result = result + "Probability: " + this.mutationProbatility_ + "\n";
        result = result + "MaxIterations: " + this.maxIterations_ + "\n";
        result = result + "Perturbation: " + this.perturbation_;
        return result;
    }
}

