/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.offspring;

import java.util.HashMap;
import jmetal.core.Operator;
import jmetal.core.Solution;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.SelectionFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.Offspring;

public class PolynomialMutationOffspring
extends Offspring {
    private Operator mutation_;
    private Operator selection_;
    private double mutationProbability_;
    private double distributionIndex_;

    public PolynomialMutationOffspring(double mutationProbability, double distributionIndexForMutation) throws JMException {
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        this.mutationProbability_ = mutationProbability;
        parameters.put("probability", this.mutationProbability_);
        this.distributionIndex_ = distributionIndexForMutation;
        parameters.put("distributionIndex", this.distributionIndex_);
        this.mutation_ = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        this.selection_ = SelectionFactory.getSelectionOperator("BinaryTournament", null);
        this.id_ = "PolynomialMutation";
    }

    public Solution getOffspring(Solution solution) {
        Solution res = new Solution(solution);
        try {
            this.mutation_.execute(res);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String configuration() {
        String result = "-----\n";
        result = result + "Operator: " + this.id_ + "\n";
        result = result + "Probability: " + this.mutationProbability_ + "\n";
        result = result + "DistributionIndex: " + this.distributionIndex_;
        return result;
    }
}

