/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.offspring;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Operator;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.SelectionFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.Offspring;

public class SBXCrossoverAndPolynomialMutationOffspring
extends Offspring {
    private double mutationProbability_ = 0.0;
    private double crossoverProbability_ = 0.9;
    private double distributionIndexForMutation_ = 20.0;
    private double distributionIndexForCrossover_ = 20.0;
    private Operator crossover_;
    private Operator mutation_;
    private Operator selection_;

    private SBXCrossoverAndPolynomialMutationOffspring(double mutationProbability, double crossoverProbability, double distributionIndexForMutation, double distributionIndexForCrossover) throws JMException {
        this.mutationProbability_ = mutationProbability;
        this.crossoverProbability_ = crossoverProbability;
        this.distributionIndexForMutation_ = distributionIndexForMutation;
        this.distributionIndexForCrossover_ = distributionIndexForCrossover;
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.distributionIndexForCrossover_);
        this.crossover_ = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.distributionIndexForMutation_);
        this.mutation_ = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        this.selection_ = SelectionFactory.getSelectionOperator("BinaryTournament", null);
        this.id_ = "SBX_Polynomial";
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            parents[0] = (Solution)this.selection_.execute(solutionSet);
            parents[1] = (Solution)this.selection_.execute(solutionSet);
            Solution[] children = (Solution[])this.crossover_.execute(parents);
            offSpring = children[0];
            this.mutation_.execute(offSpring);
        }
        catch (JMException ex) {
            Logger.getLogger(SBXCrossoverAndPolynomialMutationOffspring.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet, SolutionSet archive) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            parents[0] = (Solution)this.selection_.execute(solutionSet);
            parents[1] = archive.size() > 0 ? (Solution)this.selection_.execute(archive) : (Solution)this.selection_.execute(solutionSet);
            Solution[] children = (Solution[])this.crossover_.execute(parents);
            offSpring = children[0];
            this.mutation_.execute(offSpring);
        }
        catch (JMException ex) {
            Logger.getLogger(SBXCrossoverAndPolynomialMutationOffspring.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }
}

