/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.offspring;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Operator;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.selection.SelectionFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.Offspring;

public class SBXCrossoverOffspring
extends Offspring {
    private double crossoverProbability_ = 0.9;
    private double distributionIndexForCrossover_ = 20.0;
    private Operator crossover_;
    private Operator selection_;

    public SBXCrossoverOffspring(double crossoverProbability, double distributionIndexForCrossover) throws JMException {
        this.crossoverProbability_ = crossoverProbability;
        this.distributionIndexForCrossover_ = distributionIndexForCrossover;
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.distributionIndexForCrossover_);
        this.crossover_ = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        this.selection_ = SelectionFactory.getSelectionOperator("BinaryTournament", null);
        this.id_ = "SBXCrossover";
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            parents[0] = (Solution)this.selection_.execute(solutionSet);
            parents[1] = (Solution)this.selection_.execute(solutionSet);
            Solution[] children = (Solution[])this.crossover_.execute(parents);
            offSpring = children[0];
        }
        catch (JMException ex) {
            Logger.getLogger(SBXCrossoverOffspring.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    @Override
    public Solution getOffspring(Solution[] parentSolutions) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            parents[0] = parentSolutions[0];
            parents[1] = parentSolutions[1];
            Solution[] children = (Solution[])this.crossover_.execute(parents);
            offSpring = children[0];
        }
        catch (JMException ex) {
            Logger.getLogger(SBXCrossoverOffspring.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    @Override
    public Solution getOffspring(SolutionSet solutionSet, SolutionSet archive) {
        Solution[] parents = new Solution[2];
        Solution offSpring = null;
        try {
            parents[0] = (Solution)this.selection_.execute(solutionSet);
            parents[1] = archive.size() > 0 ? (Solution)this.selection_.execute(archive) : (Solution)this.selection_.execute(solutionSet);
            Solution[] children = (Solution[])this.crossover_.execute(parents);
            offSpring = children[0];
        }
        catch (JMException ex) {
            Logger.getLogger(SBXCrossoverOffspring.class.getName()).log(Level.SEVERE, null, ex);
        }
        return offSpring;
    }

    @Override
    public String configuration() {
        String result = "-----\n";
        result = result + "Operator: " + this.id_ + "\n";
        result = result + "Probability: " + this.crossoverProbability_ + "\n";
        result = result + "DistributionIndex: " + this.distributionIndexForCrossover_;
        return result;
    }
}

