/*
 * Decompiled with CFR 0.152.
 */
package qualityIndicator.fastHypervolume.wfg;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.qualityIndicator.fastHypervolume.FastHypervolumeArchive;
import jmetal.util.comparators.ObjectiveComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastHypervolumeArchiveTest {
    Comparator objectiveComparator_;

    @Before
    public void setup() {
        boolean descending = true;
        this.objectiveComparator_ = new ObjectiveComparator(1, true);
    }

    @Test
    public void Test1() {
        double epsilon = 1.0E-11;
        FastHypervolumeArchive archive = new FastHypervolumeArchive(4, 2);
        Solution sol1 = new Solution(2);
        sol1.setObjective(0, 4.6);
        sol1.setObjective(1, 8.0);
        Solution sol2 = new Solution(2);
        sol2.setObjective(0, 5.35);
        sol2.setObjective(1, 7.0);
        Solution sol3 = new Solution(2);
        sol3.setObjective(0, 6.7);
        sol3.setObjective(1, 6.0);
        Solution sol4 = new Solution(2);
        sol4.setObjective(0, 8.9);
        sol4.setObjective(1, 5.0);
        archive.add(sol1);
        archive.add(sol2);
        archive.add(sol3);
        archive.add(sol4);
        archive.computeHVContribution();
        Assert.assertEquals((String)"Test 1", (double)archive.referencePoint_.getObjective(0), (double)8.9, (double)epsilon);
        Assert.assertEquals((String)"Test 1", (double)(archive.referencePoint_.getObjective(1) + 10.0), (double)8.0, (double)epsilon);
    }

    public void Test2() {
        double epsilon = 1.0E-11;
        FastHypervolumeArchive archive = new FastHypervolumeArchive(4, 2);
        Solution sol1 = new Solution(2);
        sol1.setObjective(0, 4.6);
        sol1.setObjective(1, 8.0);
        Solution sol2 = new Solution(2);
        sol2.setObjective(0, 5.35);
        sol2.setObjective(1, 7.0);
        Solution sol3 = new Solution(2);
        sol3.setObjective(0, 6.7);
        sol3.setObjective(1, 6.0);
        Solution sol4 = new Solution(2);
        sol4.setObjective(0, 8.9);
        sol4.setObjective(1, 5.0);
        archive.add(sol1);
        archive.add(sol2);
        archive.add(sol3);
        archive.add(sol4);
        archive.computeHVContribution();
        Assert.assertEquals((String)"Test 1", (double)(archive.referencePoint_.getObjective(0) + 10.0), (double)8.9, (double)epsilon);
        Assert.assertEquals((String)"Test 1", (double)(archive.referencePoint_.getObjective(1) + 10.0), (double)8.0, (double)epsilon);
    }
}

