/*
 * Decompiled with CFR 0.152.
 */
package mutalog.core;

import java.util.ArrayList;
import java.util.List;
import mutalog.core.Literal;
import org.sat4j.core.VecInt;

public class Clause {
    private List<Literal> literals;

    public Clause() {
        this.literals = new ArrayList<Literal>();
    }

    public Clause(int size) {
        this.literals = new ArrayList<Literal>(size);
    }

    public Clause(Clause clause) {
        this();
        for (Literal l : clause.getLiterals()) {
            this.literals.add(new Literal(l));
        }
    }

    public boolean contains(Literal l) {
        return this.literals.contains(l);
    }

    public List<Literal> getLiterals() {
        return this.literals;
    }

    public int nLiterals() {
        return this.literals.size();
    }

    public Literal getILiteral(int index) {
        return this.literals.get(index);
    }

    public boolean isEmpty() {
        return this.literals.isEmpty();
    }

    public void setLiterals(List<Literal> literals) {
        this.literals = literals;
    }

    public void addLiteral(Literal l) {
        this.literals.add(l);
    }

    public void removeLiteral(int index) {
        this.literals.remove(index);
    }

    public VecInt toVecInt() {
        VecInt v = new VecInt(this.literals.size());
        for (Literal l : this.literals) {
            v.push(l.getValue());
        }
        return v;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.literals != null ? ((Object)this.literals).hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clause other = (Clause)obj;
        return this.literals == other.literals || this.literals != null && ((Object)this.literals).equals(other.literals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.literals.size() > 1) {
            sb.append("(");
        }
        int n = 0;
        for (Literal l : this.literals) {
            if (n++ != 0) {
                sb.append(" || ");
            }
            sb.append(l.toString());
        }
        if (this.literals.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }
}

