/*
 * Decompiled with CFR 0.152.
 */
package mutalog.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mutalog.core.CNFFormula;
import mutalog.core.Clause;
import mutalog.core.Literal;
import mutalog.core.Mutant;
import mutalog.core.Test;
import mutalog.core.TestSuite;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ISolver;

public class ModelMutaLog
extends Observable {
    private static final String GLOBAL_ACTION_LOAD_FORMULA = "Loading the CNF formula";
    private static final String CURRENT_ACTION_LOAD_CLAUSES = "Parsing the clauses...";
    private static final String GLOBAL_ACTION_LOAD_TEST_SUITE = "Loading the test suite";
    private static final String CURRENT_ACTION_LOAD_TEST = "Parsing the tests...";
    private static final String GLOBAL_ACTION_CREATE_MUTANTS = "Creating mutants";
    private static final String CURRENT_ACTION_LITERAL_OMISSION_MUTANT = "Literal omission mutants...";
    private static final String CURRENT_ACTION_LITERAL_NEGATION_MUTANT = "Literal negation mutants...";
    private static final String CURRENT_ACTION_CLAUSE_OMISSION_MUTANT = "Clause omission mutants...";
    private static final String CURRENT_ACTION_CLAUSE_NEGATION_MUTANT = "Clause negation mutants...";
    private static final String CURRENT_ACTION_OPERATOR_AND_MUTANT = "Operator AND mutants...";
    private static final String CURRENT_ACTION_OPERATOR_OR_MUTANT = "Operator OR mutants...";
    private static final String GLOBAL_ACTION_EVAL_TEST_SUITE = "Evaluating the test suite";
    private static final String CURRENT_ACTION_EVAL_MUTANTS = "Evaluating the mutants...";
    private CNFFormula formula;
    private TestSuite testSuite;
    private List<Mutant> mutants = new ArrayList<Mutant>();
    private String globalAction;
    private String currentAction;
    private boolean running = false;
    private boolean indeterminate = true;
    private int progress = 0;
    private int killed;
    private int totalOk;

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (!running) {
            this.indeterminate = true;
        }
        this.progress = 0;
        this.setChanged();
        this.notifyObservers();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.setChanged();
        this.notifyObservers();
    }

    public String getGlobalAction() {
        return this.globalAction;
    }

    public void setGlobalAction(String globalAction) {
        this.globalAction = globalAction;
        this.setChanged();
        this.notifyObservers();
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(String currentAction) {
        this.currentAction = currentAction;
        this.setChanged();
        this.notifyObservers();
    }

    public void parseCNFFormula(String file) {
        this.setRunning(true);
        this.setGlobalAction(GLOBAL_ACTION_LOAD_FORMULA);
        this.setCurrentAction(CURRENT_ACTION_LOAD_CLAUSES);
        this.formula = new CNFFormula();
        this.testSuite = null;
        this.mutants.clear();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                int token;
                if ((line = line.trim()).startsWith("c")) continue;
                StringTokenizer st = new StringTokenizer(line, " ");
                if (line.startsWith("p")) {
                    st.nextToken();
                    st.nextToken();
                    this.formula.setnVars(Integer.parseInt(st.nextToken()));
                    continue;
                }
                Clause clause = new Clause(st.countTokens());
                while (st.hasMoreTokens() && (token = Integer.parseInt(st.nextToken())) != 0) {
                    clause.addLiteral(new Literal(token));
                }
                if (clause.isEmpty()) continue;
                this.formula.addClause(clause);
            }
            in.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ModelMutaLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ModelMutaLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers();
    }

    public void parseTestSuite(String file) throws FileNotFoundException, IOException {
        String line;
        this.setRunning(true);
        this.setGlobalAction(GLOBAL_ACTION_LOAD_TEST_SUITE);
        this.setCurrentAction(CURRENT_ACTION_LOAD_TEST);
        this.testSuite = new TestSuite();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            line = line.trim();
            StringTokenizer st = new StringTokenizer(line, " ");
            Test test = new Test(st.countTokens());
            while (st.hasMoreTokens()) {
                int token = Integer.parseInt(st.nextToken());
                test.addValue(token);
            }
            this.testSuite.add(test);
        }
        in.close();
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers();
    }

    public void quit() {
        System.exit(0);
    }

    public CNFFormula getFormula() {
        return this.formula;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public List<Mutant> getMutants() {
        return this.mutants;
    }

    public void createMutants(boolean literalOmission, boolean literalNegation, boolean clauseOmission, boolean clauseNegation, boolean operatorAnd, boolean operatorOr) {
        this.setRunning(true);
        this.setGlobalAction(GLOBAL_ACTION_CREATE_MUTANTS);
        this.setChanged();
        this.notifyObservers();
        this.mutants.clear();
        if (literalOmission) {
            this.setCurrentAction(CURRENT_ACTION_LITERAL_OMISSION_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getLiteralOmissionMutants());
        }
        if (literalNegation) {
            this.setCurrentAction(CURRENT_ACTION_LITERAL_NEGATION_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getLiteralNegationMutants());
        }
        if (clauseOmission) {
            this.setCurrentAction(CURRENT_ACTION_CLAUSE_OMISSION_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getClauseOmissionMutants());
        }
        if (clauseNegation) {
            this.setCurrentAction(CURRENT_ACTION_CLAUSE_NEGATION_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getClauseNegationMutants());
        }
        if (operatorAnd) {
            this.setCurrentAction(CURRENT_ACTION_OPERATOR_AND_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getOperatorReferenceAndMutants());
        }
        if (operatorOr) {
            this.setCurrentAction(CURRENT_ACTION_OPERATOR_OR_MUTANT);
            this.setChanged();
            this.notifyObservers();
            this.mutants.addAll(this.formula.getOperatorReferenceOrMutants());
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers();
    }

    public void evaluateMutationScore(boolean literalOmission, boolean literalNegation, boolean clauseOmission, boolean clauseNegation, boolean operatorAnd, boolean operatorOr, boolean print) {
        this.createMutants(literalOmission, literalNegation, clauseOmission, clauseNegation, operatorAnd, operatorOr);
        this.setRunning(true);
        this.setGlobalAction(GLOBAL_ACTION_EVAL_TEST_SUITE);
        this.setCurrentAction(CURRENT_ACTION_EVAL_MUTANTS);
        this.setChanged();
        this.notifyObservers();
        this.killed = 0;
        this.totalOk = 0;
        block4: for (Mutant m : this.mutants) {
            boolean mutantOk = true;
            ISolver solver = SolverFactory.newDefault();
            solver.newVar(m.nVars);
            solver.setExpectedNumberOfClauses(m.nClauses());
            for (Clause c : m.getClauses()) {
                try {
                    VecInt v = c.toVecInt();
                    solver.addClause(v);
                }
                catch (Exception ex) {
                    mutantOk = false;
                    break;
                }
            }
            if (mutantOk) {
                ++this.totalOk;
                m.setInvalid(false);
                for (Test t : this.testSuite.getTests()) {
                    VecInt test = t.toVecInt();
                    System.out.println(t);
                    try {
                        if (!solver.isSatisfiable(test)) {
                            m.setKilled(true);
                            ++this.killed;
                            System.out.println("(killed)  " + m.toStringMutant());
                            continue block4;
                        }
                        System.out.println("(live)  " + m.toStringMutant());
                    }
                    catch (Exception ex) {}
                }
                continue;
            }
            m.setInvalid(true);
            System.out.println("(invalid)  " + m.toStringMutant());
        }
        if (print) {
            System.out.println("Score: " + this.killed + " / " + this.totalOk + " (" + (this.mutants.size() - this.totalOk) + " invalid)");
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers("score");
    }

    public int getKilled() {
        return this.killed;
    }

    public void setKilled(int killed) {
        this.killed = killed;
    }

    public int getTotalOk() {
        return this.totalOk;
    }

    public void setTotalOk(int totalOk) {
        this.totalOk = totalOk;
    }
}

