/*
 * Decompiled with CFR 0.152.
 */
package mutalog.gui.views;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mutalog.core.ModelMutaLog;

public class ViewMenuBar
extends JMenuBar
implements Observer {
    private static final String FILE = "File";
    private static final String EXECUTE = "Execute";
    private static final String HELP = "Help";
    private static final String LOAD_FORMULA = "Load a CNF formula...";
    private static final String LOAD_TEST_SUITE = "Load a test suite...";
    private static final String QUIT = "Quit";
    public static final String COMPUTE_MUT_SCORE = "Evaluate the mutation score";
    public static final String STOP = "Stop the execution";
    public static final String DOC = "Documentation";
    public static final String ABOUT = "About MutaLog...";
    private ModelMutaLog model;
    private JMenu file;
    private JMenu execute;
    private JMenu help;
    private JMenuItem loadFormula;
    private JMenuItem loadTestSuite;
    private JMenuItem quit;
    private JMenuItem coverage;
    private JMenuItem stop;
    private JMenuItem about;
    private JMenuItem doc;
    private ImageIcon loadFormulaIcon;
    private ImageIcon loadTestSuiteIcon;
    private ImageIcon quitIcon;
    private ImageIcon stopIcon;
    private ImageIcon coverageIcon;
    private final URL urlLoadFormula = this.getClass().getResource("icons/load_formula.png");
    private final URL urlLoadTestSuite = this.getClass().getResource("icons/load_testsuite.png");
    private final URL urlQuit = this.getClass().getResource("icons/exit.png");
    private final URL urlCoverage = this.getClass().getResource("icons/coverage.png");
    private final URL urlStop = this.getClass().getResource("icons/stop.png");

    public ViewMenuBar(ModelMutaLog model) {
        this.model = model;
        model.addObserver(this);
        this.loadFormulaIcon = new ImageIcon(this.urlLoadFormula);
        this.loadTestSuiteIcon = new ImageIcon(this.urlLoadTestSuite);
        this.quitIcon = new ImageIcon(this.urlQuit);
        this.coverageIcon = new ImageIcon(this.urlCoverage);
        this.stopIcon = new ImageIcon(this.urlStop);
        this.loadFormula = new JMenuItem(LOAD_FORMULA, this.loadFormulaIcon);
        this.loadFormula.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.loadTestSuite = new JMenuItem(LOAD_TEST_SUITE, this.loadTestSuiteIcon);
        this.loadTestSuite.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.quit = new JMenuItem(QUIT, this.quitIcon);
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.coverage = new JMenuItem(COMPUTE_MUT_SCORE, this.coverageIcon);
        this.coverage.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        this.stop = new JMenuItem(STOP, this.stopIcon);
        this.stop.setAccelerator(KeyStroke.getKeyStroke(75, 8));
        this.doc = new JMenuItem(DOC);
        this.doc.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.about = new JMenuItem(ABOUT);
        this.about.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.file = new JMenu(FILE);
        this.file.setMnemonic(70);
        this.file.add(this.loadFormula);
        this.file.add(this.loadTestSuite);
        this.file.addSeparator();
        this.file.add(this.quit);
        this.add(this.file);
        this.execute = new JMenu(EXECUTE);
        this.execute.setMnemonic(69);
        this.execute.add(this.coverage);
        this.execute.add(this.coverage);
        this.execute.add(this.stop);
        this.execute.addSeparator();
        this.add(this.execute);
        this.help = new JMenu(HELP);
        this.help.setMnemonic(72);
        this.help.add(this.doc);
        this.help.addSeparator();
        this.help.add(this.about);
        this.add(this.help);
        this.loadTestSuite.setEnabled(model.getFormula() != null);
        this.coverage.setEnabled(model.getTestSuite() != null);
        this.stop.setEnabled(model.isRunning());
        this.execute.setEnabled(this.stop.isEnabled() || this.coverage.isEnabled());
    }

    public JMenuItem getLoadFormula() {
        return this.loadFormula;
    }

    public JMenuItem getLoadTestSuite() {
        return this.loadTestSuite;
    }

    public JMenuItem getQuit() {
        return this.quit;
    }

    public JMenuItem getCoverage() {
        return this.coverage;
    }

    public JMenuItem getStop() {
        return this.stop;
    }

    public JMenuItem getAbout() {
        return this.about;
    }

    public JMenuItem getDoc() {
        return this.doc;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setEnabled();
    }

    private void setEnabled() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewMenuBar.this.loadTestSuite.setEnabled(ViewMenuBar.this.model.getFormula() != null);
                ViewMenuBar.this.coverage.setEnabled(ViewMenuBar.this.model.getTestSuite() != null);
                ViewMenuBar.this.stop.setEnabled(ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.execute.setEnabled(ViewMenuBar.this.stop.isEnabled() || ViewMenuBar.this.coverage.isEnabled());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

