/*
 * Decompiled with CFR 0.152.
 */
package mutalog.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import mutalog.core.ModelMutaLog;
import mutalog.gui.views.ViewAboutWindow;
import mutalog.gui.views.ViewDocumentation;
import mutalog.gui.views.ViewFormula;
import mutalog.gui.views.ViewMenuBar;
import mutalog.gui.views.ViewMutants;
import mutalog.gui.views.ViewMutantsConfiguration;
import mutalog.gui.views.ViewStatusBar;
import mutalog.gui.views.ViewTestSuite;
import mutalog.gui.views.ViewToolBar;
import mutalog.gui.views.controllers.ControllerCloseAbout;
import mutalog.gui.views.controllers.ControllerCoverage;
import mutalog.gui.views.controllers.ControllerDisplayAbout;
import mutalog.gui.views.controllers.ControllerDisplayDocumentation;
import mutalog.gui.views.controllers.ControllerLoadFormula;
import mutalog.gui.views.controllers.ControllerLoadTestSuite;
import mutalog.gui.views.controllers.ControllerQuit;
import mutalog.gui.views.controllers.ControllerRunCoverage;

public class ViewMutaLog
extends JFrame
implements Observer {
    public static final Color BLUE_COLOR = new Color(232, 239, 247);
    public static final int D_WIDTH = 900;
    public static final int D_HEIGHT = 600;
    public static final String TITLE = "MutaLog - a Tool for Mutating Logic Formulas";
    public static final String MUTATION_SCORE = "Mutation score";
    private static final String QUIT_MESSAGE = "Quit MutaLog will interrupt any running task. Do you want to continue ?";
    private static final String QUIT_TITLE = "Quit MutaLog";
    private static final String FILE_CHOOSER_FORMULA_TITLE = "Load a CNF formula";
    private static final String FILE_CHOOSER_TEST_SUITE_TITLE = "Load a test suite";
    private static final String ERROR = "Error";
    private static final String NO_MUTANTS_SELECTED = "No mutant selected";
    private final FileNameExtensionFilter formulaFileFilter = new FileNameExtensionFilter("DIMACS format (.dimacs)", "dimacs");
    private final URL BACKGROUND_URL = this.getClass().getResource("icons/mutalog.png");
    private ModelMutaLog model = new ModelMutaLog();
    private ControllerDisplayAbout controllerDisplayAbout;
    private ControllerCloseAbout controllerCloseAbout;
    private ControllerQuit controllerQuit;
    private ControllerLoadFormula controllerLoadFormula;
    private ControllerLoadTestSuite controllerLoadTestSuite;
    private ControllerDisplayDocumentation controllerDisplayDocumentation;
    private ControllerCoverage controllerCoverage;
    private ControllerRunCoverage controllerRunCoverage;
    private ViewMenuBar viewMenuBar;
    private ViewStatusBar viewStatusBar;
    private ViewAboutWindow viewAboutWindow;
    private ViewFormula viewFormula;
    private ViewTestSuite viewTestSuite;
    private ViewMutantsConfiguration viewMutantsConfiguration;
    private ViewMutants viewMutants;
    private ViewToolBar viewToolBar;
    private ViewDocumentation viewDocumentation;
    private JPanel content;
    private JPanel background;
    private JFileChooser formulaChooser;
    private JFileChooser testSuiteChooser;
    private JSplitPane splitPane;

    public ViewMutaLog() {
        super(TITLE);
        this.model.addObserver(this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ViewMutaLog.this.viewDocumentation = ViewDocumentation.getInstance();
                ViewMutaLog.this.viewDocumentation.setLocationRelativeTo(ViewMutaLog.this);
            }
        }).start();
        this.viewAboutWindow = new ViewAboutWindow(this);
        this.viewStatusBar = new ViewStatusBar(this.model);
        this.viewMenuBar = new ViewMenuBar(this.model);
        this.viewFormula = new ViewFormula(this.model);
        this.viewTestSuite = new ViewTestSuite(this.model);
        this.viewMutantsConfiguration = new ViewMutantsConfiguration(this.model);
        this.viewMutants = new ViewMutants(this.model);
        this.viewToolBar = new ViewToolBar(this.model);
        this.controllerQuit = new ControllerQuit(this.model, this);
        this.controllerLoadFormula = new ControllerLoadFormula(this.model, this);
        this.controllerLoadTestSuite = new ControllerLoadTestSuite(this.model, this);
        this.controllerDisplayAbout = new ControllerDisplayAbout(this);
        this.controllerCloseAbout = new ControllerCloseAbout(this);
        this.controllerDisplayDocumentation = new ControllerDisplayDocumentation(this);
        this.controllerCoverage = new ControllerCoverage(this.model, this);
        this.controllerRunCoverage = new ControllerRunCoverage(this.model, this, this.viewMutantsConfiguration);
        this.viewAboutWindow.getCloseButton().addActionListener(this.controllerCloseAbout);
        this.viewMenuBar.getQuit().addActionListener(this.controllerQuit);
        this.viewMenuBar.getLoadFormula().addActionListener(this.controllerLoadFormula);
        this.viewMenuBar.getLoadTestSuite().addActionListener(this.controllerLoadTestSuite);
        this.viewMenuBar.getAbout().addActionListener(this.controllerDisplayAbout);
        this.viewMenuBar.getDoc().addActionListener(this.controllerDisplayDocumentation);
        this.viewMenuBar.getCoverage().addActionListener(this.controllerCoverage);
        this.viewToolBar.getQuit().addActionListener(this.controllerQuit);
        this.viewToolBar.getLoadFormula().addActionListener(this.controllerLoadFormula);
        this.viewToolBar.getLoadTestSuite().addActionListener(this.controllerLoadTestSuite);
        this.viewToolBar.getCoverage().addActionListener(this.controllerCoverage);
        this.viewMutantsConfiguration.getOk().addActionListener(this.controllerRunCoverage);
        this.splitPane = new JSplitPane(1);
        this.setJMenuBar(this.viewMenuBar);
        this.formulaChooser = new JFileChooser();
        this.formulaChooser.setMultiSelectionEnabled(false);
        this.formulaChooser.setAcceptAllFileFilterUsed(false);
        this.formulaChooser.addChoosableFileFilter(this.formulaFileFilter);
        this.formulaChooser.setDialogTitle(FILE_CHOOSER_FORMULA_TITLE);
        this.testSuiteChooser = new JFileChooser();
        this.testSuiteChooser.setMultiSelectionEnabled(false);
        this.testSuiteChooser.setAcceptAllFileFilterUsed(false);
        this.testSuiteChooser.setDialogTitle(FILE_CHOOSER_TEST_SUITE_TITLE);
        this.add((Component)this.viewStatusBar, "South");
        this.content = new JPanel(new BorderLayout());
        this.background = new JPanel(new GridLayout(1, 1));
        this.background.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(172, 168, 153)));
        this.background.setBackground(Color.white);
        this.background.add((Component)new JLabel(new ImageIcon(this.BACKGROUND_URL)), "Center");
        this.add((Component)this.background, "Center");
        this.add((Component)this.viewToolBar, "First");
        this.setSize(900, 600);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public boolean getQuitConfirmation() {
        return JOptionPane.showConfirmDialog(this, QUIT_MESSAGE, QUIT_TITLE, 0) == 0;
    }

    @Override
    public void update(Observable o, final Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewMutaLog.this.content.removeAll();
                if (ViewMutaLog.this.model.getFormula() != null) {
                    ViewMutaLog.this.remove(ViewMutaLog.this.background);
                    ViewMutaLog.this.add((Component)ViewMutaLog.this.content, "Center");
                    ViewMutaLog.this.viewStatusBar.addSeparator();
                    ViewMutaLog.this.content.add((Component)ViewMutaLog.this.viewFormula, "North");
                }
                if (ViewMutaLog.this.model.getTestSuite() != null) {
                    ViewMutaLog.this.content.add((Component)ViewMutaLog.this.viewTestSuite, "Center");
                    if (ViewMutaLog.this.model.getMutants().size() > 0) {
                        ViewMutaLog.this.splitPane.setLeftComponent(ViewMutaLog.this.viewTestSuite);
                        ViewMutaLog.this.splitPane.setRightComponent(ViewMutaLog.this.viewMutants);
                        ViewMutaLog.this.content.add((Component)ViewMutaLog.this.splitPane, "Center");
                    }
                } else {
                    ViewMutaLog.this.splitPane.removeAll();
                    ViewMutaLog.this.content.remove(ViewMutaLog.this.splitPane);
                }
                if (arg != null) {
                    ViewMutaLog.this.displayScore();
                }
                ViewMutaLog.this.validate();
                SwingUtilities.updateComponentTreeUI(ViewMutaLog.this);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayViewAboutWindow(final boolean display) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewMutaLog.this.viewAboutWindow.setVisible(display);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public File displayFormulaChooser() {
        if (this.formulaChooser.showOpenDialog(this) == 0) {
            return this.formulaChooser.getSelectedFile();
        }
        return null;
    }

    public File displayTestSuiteChooser() {
        if (this.testSuiteChooser.showOpenDialog(this) == 0) {
            return this.testSuiteChooser.getSelectedFile();
        }
        return null;
    }

    public void displayDocumentation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewMutaLog.this.viewDocumentation.setVisible(true);
            }
        });
    }

    public void displayMutantsConfiguration() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewMutaLog.this.viewMutantsConfiguration.setLocationRelativeTo(ViewMutaLog.this);
                ViewMutaLog.this.viewMutantsConfiguration.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayErrorMessageNoMutants() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ViewMutaLog.this, ViewMutaLog.NO_MUTANTS_SELECTED, ViewMutaLog.ERROR, 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayScore() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ViewMutaLog.this, ViewMutaLog.this.model.getKilled() + " / " + ViewMutaLog.this.model.getTotalOk() + " (" + (ViewMutaLog.this.model.getMutants().size() - ViewMutaLog.this.model.getTotalOk()) + " invalid mutants)", ViewMutaLog.MUTATION_SCORE, 1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

