/*
 * Decompiled with CFR 0.152.
 */
package mutalog.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import mutalog.core.ModelMutaLog;

public class ViewStatusBar
extends JPanel
implements Observer {
    private static final String INIT_MESSAGE = "No file loaded";
    private static final String END_MESSAGE = "Completed";
    private ModelMutaLog model;
    private JLabel currentAction;
    private JLabel globalAction;
    private JProgressBar progressBar;
    private JPanel action;
    private JPanel status;
    private JSeparator separator;

    public ViewStatusBar(ModelMutaLog model) {
        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        this.globalAction = new JLabel(INIT_MESSAGE);
        this.currentAction = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.action = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 22;
        c.insets = new Insets(2, 5, 2, 5);
        this.action.add((Component)this.currentAction, c);
        c.gridx = 1;
        this.action.add((Component)this.progressBar, c);
        this.status = new JPanel(new GridBagLayout());
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(5, 5, 4, 5);
        this.status.add((Component)this.globalAction, c);
        this.separator = new JSeparator();
        this.action.setVisible(false);
        this.add((Component)this.action, "East");
        this.add((Component)this.status, "West");
    }

    public void addSeparator() {
        this.add((Component)this.separator, "North");
    }

    public void removeSeparator() {
        this.remove(this.separator);
    }

    @Override
    public void update(Observable o, Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (ViewStatusBar.this.model.isRunning()) {
                    ViewStatusBar.this.action.setVisible(true);
                    ViewStatusBar.this.globalAction.setText(ViewStatusBar.this.model.getGlobalAction());
                    ViewStatusBar.this.currentAction.setText(ViewStatusBar.this.model.getCurrentAction());
                    if (!ViewStatusBar.this.model.isIndeterminate()) {
                        ViewStatusBar.this.progressBar.setIndeterminate(false);
                        ViewStatusBar.this.progressBar.setStringPainted(true);
                        int progress = ViewStatusBar.this.model.getProgress();
                        ViewStatusBar.this.progressBar.setValue(progress);
                    } else {
                        ViewStatusBar.this.progressBar.setIndeterminate(true);
                        ViewStatusBar.this.progressBar.setStringPainted(false);
                    }
                } else {
                    ViewStatusBar.this.action.setVisible(false);
                    ViewStatusBar.this.globalAction.setText(ViewStatusBar.END_MESSAGE);
                    ViewStatusBar.this.progressBar.setIndeterminate(true);
                    ViewStatusBar.this.progressBar.setStringPainted(false);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

