/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

public class CommandLineParser {

    private JCommander jCommander;
    private Mutation commandMutation;
    private String[] args;
    public static final String MUTATION = "mutation_score";

    public CommandLineParser(String[] args, String programName) {
        this.args = args;

        commandMutation = new Mutation();
        jCommander = new JCommander();
        jCommander.addCommand(MUTATION, commandMutation);
        jCommander.setProgramName("java -jar " + programName + ".jar");

    }

    @Parameters(commandDescription = "Evaluate the mutation score of the test suite")
    public class Mutation {

        @Parameter(names = "-f", description = "The CNF formula file (.dimacs)", required = true)
        public String fmFile;
        @Parameter(names = "-ts", description = "The test suite file", required = true)
        public String testFile;
        @Parameter(names = "-lo", description = "Use literal omission mutants")
        public boolean lo = false;
        @Parameter(names = "-ln", description = "Use literal negation mutants")
        public boolean ln = false;
        @Parameter(names = "-co", description = "Use clause omission mutants")
        public boolean co = false;
        @Parameter(names = "-cn", description = "Use clause negation mutants")
        public boolean cn = false;
        @Parameter(names = "-and", description = "Use operator AND mutants")
        public boolean and = false;
        @Parameter(names = "-or", description = "Use operator OR mutants")
        public boolean or = false;
    }

    public Mutation getCommandMutation() {
        return commandMutation;
    }

    public void parseArgs() {
        jCommander.parse(args);
    }

    public String getCommandName() {
        return jCommander.getParsedCommand();
    }

    public void printUsage() {
        jCommander.usage();
    }
}
