/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog;

import java.util.logging.Level;
import java.util.logging.Logger;
import mutalog.core.ModelMutaLog;
import mutalog.gui.GUI;

public class MutaLog {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new GUI();
            } else {
                CommandLineParser parser = new CommandLineParser(args, "MutaLog");
                try {

                    parser.parseArgs();
                    if (parser.getCommandName().equals(CommandLineParser.MUTATION)) {
                        ModelMutaLog model = new ModelMutaLog();
                        model.parseCNFFormula(parser.getCommandMutation().fmFile);
                        model.parseTestSuite(parser.getCommandMutation().testFile);
                        model.evaluateMutationScore(parser.getCommandMutation().lo, parser.getCommandMutation().ln, parser.getCommandMutation().co, parser.getCommandMutation().cn, parser.getCommandMutation().and, parser.getCommandMutation().or, true);
                    }
                } catch (Exception e) {
                    parser.printUsage();

                }
            }



        } catch (Exception ex) {
            Logger.getLogger(MutaLog.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
}
