/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.core;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;

public class Clause {

    private List<Literal> literals;

    public Clause() {
        literals = new ArrayList<Literal>();
    }

    public Clause(int size) {
        literals = new ArrayList<Literal>(size);
    }

    public Clause(Clause clause) {
        this();
        for (Literal l : clause.getLiterals()) {
            literals.add(new Literal(l));
        }
    }

    public boolean contains(Literal l) {
        return literals.contains(l);
    }

    public List<Literal> getLiterals() {
        return literals;
    }

    public int nLiterals() {
        return literals.size();
    }

    public Literal getILiteral(int index) {
        return literals.get(index);
    }

    public boolean isEmpty() {
        return literals.isEmpty();
    }

    public void setLiterals(List<Literal> literals) {
        this.literals = literals;
    }

    public void addLiteral(Literal l) {
        literals.add(l);
    }

    public void removeLiteral(int index) {
        literals.remove(index);
    }

    public VecInt toVecInt() {
        VecInt v = new VecInt(literals.size());
        for (Literal l : literals) {
            v.push(l.getValue());
        }
        return v;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.literals != null ? this.literals.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Clause other = (Clause) obj;
        if (this.literals != other.literals && (this.literals == null || !this.literals.equals(other.literals))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (literals.size() > 1) {
            sb.append("(");
        }
        int n = 0;
        for (Literal l : literals) {
            if (n++ != 0) {
                sb.append(" || ");
            }
            sb.append(l.toString());
        }
        if (literals.size() > 1) {
            sb.append(")");
        }
        return sb.toString();

    }
}
