/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.core;

public class Mutant extends CNFFormula {

    private boolean killed, invalid;
    private String type;
    public static final String LIT_NEG = "(LIT. NEG.)";
    public static final String LIT_OM = "(LIT. OM.)";
    public static final String CLAUSE_NEG = "(CLAUSE NEG.)";
    public static final String CLAUSE_OM = "(CLAUSE OM.)";
    public static final String OP_OR = "(OP. OR)";
    public static final String OP_AND = "(OP. AND)";

    public Mutant() {
        super();
        killed = false;
    }

    public Mutant(CNFFormula formula, String type) {
        super(formula);
        this.type = type;
    }

    public boolean isKilled() {
        return killed;
    }

    public void setKilled(boolean killed) {
        this.killed = killed;
    }

    public boolean isInvalid() {
        return invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toStringMutant() {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (int i = 0; i < clauses.size(); i++) {
            Clause c = clauses.get(i);
            if (n++ != 0) {
                sb.append(" && ");
            }
            sb.append(c.toString());
        }
        return type + "    " + sb.toString();

    }
}
