/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.core;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;

public class Test {

    private List<Integer> values;

    public Test(int size) {
        values = new ArrayList<Integer>(size);
    }

    public void addValue(int val) {
        values.add(val);
    }

    public VecInt toVecInt() {
        VecInt v = new VecInt(values.size());
        for (Integer i : values) {
            v.push(i);
        }
        return v;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        int n = 0;
        for (Integer i : values) {
            if (n++ != 0) {
                sb.append(" ");
            }
            sb.append(i.toString());
        }

        return sb.toString();

    }
}
