/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui;

import javax.swing.AbstractListModel;
import mutalog.core.ModelMutaLog;
import mutalog.core.Mutant;

public class AdapterMutants extends AbstractListModel {

    private ModelMutaLog model;

    public AdapterMutants(ModelMutaLog model) {
        this.model = model;
    }

    @Override
    public int getSize() {
        if (model.getMutants() != null) {
            return model.getMutants().size();

        }
        return 0;
    }

    @Override
    public Object getElementAt(int index) {
        if (model.getMutants() != null) {

            Mutant m = model.getMutants().get(index);
            String s;

            if (m.isInvalid()) {
                s = "<html><body><s>M" + (index + 1) + " (Invalid)    " + m.toStringMutant() + "</s></body></html>";
            } else if (m.isKilled()) {
                s = "<html><body><font color=\"red\">M" + (index + 1) + " (Killed)    " + m.toStringMutant() + "</font></body></html>";
            } else {
                s = "M" + (index + 1) + "    " + m.toStringMutant();
            }
            return s;

        }
        return null;

    }

    public void update() {
        fireContentsChanged(this, 0, getSize() - 1);
    }
}
