/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui;

import javax.swing.AbstractListModel;
import mutalog.core.ModelMutaLog;
import mutalog.core.Test;

public class AdapterTestSuite extends AbstractListModel {

    private ModelMutaLog model;

    public AdapterTestSuite(ModelMutaLog model) {
        this.model = model;
    }

    @Override
    public int getSize() {
        if (model.getTestSuite() != null) {
            return model.getTestSuite().getSize();

        }
        return 0;
    }

    @Override
    public Object getElementAt(int index) {
        if (model.getTestSuite() != null) {

            Test t = model.getTestSuite().getITest(index);
            String s = "T" + (index + 1) + "    " + t;

            return s;

        }
        return null;

    }

    public void update() {
        fireContentsChanged(this, 0, getSize() - 1);
    }
}
