/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui.views;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import mutalog.core.ModelMutaLog;

public class ViewFormula extends JPanel implements Observer {

    private static final String TITLE = "CNF Formula";
    private static final String INFO_TITLE = "Information";
    private static final String CLAUSES_TITLE = "Clauses";
    public static final String VARS = "Number of variables:";
    public static final String CLAUSES = "Number of clauses:";
    public static final String DEAD = "Number of dead features:";
    private JPanel info, formula;
    private JLabel varsLabel, vars;
    private JLabel clausesLabel, clauses;
    private JTextArea area;
    private JScrollPane pane;
    private ModelMutaLog model;

    public ViewFormula(ModelMutaLog model) {

        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        info = new JPanel(new GridBagLayout());
        info.setBorder(BorderFactory.createTitledBorder(INFO_TITLE));
        formula = new JPanel(new GridLayout(1, 1));
        formula.setBorder(BorderFactory.createTitledBorder(CLAUSES_TITLE));


        setBorder(BorderFactory.createTitledBorder(TITLE));
        varsLabel = new JLabel(VARS);
        vars = new JLabel("-", SwingConstants.LEFT);
        clausesLabel = new JLabel(CLAUSES);
        clauses = new JLabel("-", SwingConstants.LEFT);

        GridBagConstraints c = new GridBagConstraints();

        Insets i = new Insets(20, 15, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = i;
        c.anchor = GridBagConstraints.BASELINE_TRAILING;
        info.add(varsLabel, c);

        i = new Insets(20, 15, 0, 0);
        c.gridx = 1;
        c.insets = i;
        c.anchor = GridBagConstraints.BASELINE_LEADING;
        info.add(vars, c);

        c.gridx = 2;
        c.anchor = GridBagConstraints.BASELINE_TRAILING;
        info.add(clausesLabel, c);

        c.gridx = 3;
        c.anchor = GridBagConstraints.BASELINE_LEADING;
        info.add(clauses, c);

        area = new JTextArea();
        area.setEditable(false);
        pane = new JScrollPane(area);
        pane.setPreferredSize(new Dimension(100, 200));
        formula.add(pane);

        add(info, BorderLayout.NORTH);
        add(formula, BorderLayout.CENTER);

    }

    @Override
    public void update(Observable o, Object arg) {
        Runnable code = new Runnable() {
            @Override
            public void run() {
                if (model.getFormula() != null) {
                    vars.setText("" + model.getFormula().nVars());
                    clauses.setText("" + model.getFormula().nClauses());
                    area.setText(model.getFormula().toString());

                    ViewFormula.this.validateTree();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}
