/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui.views;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import mutalog.core.ModelMutaLog;

public class ViewMutantsConfiguration extends JDialog implements Observer {

    private static final String TITLE = "Mutants configuration";
    private static final String OK_TEXT = "Ok";
    private static final String CANCEL_TEXT = "Cancel";
    public static final int D_WIDTH = 400, D_HEIGHT = 300;
    private static final String LITERAL_OMISSION_MUTANT = "Literal omission mutants";
    private static final String LITERAL_NEGATION_MUTANT = "Literal negation mutants";
    private static final String CLAUSE_OMISSION_MUTANT = "Clause omission mutants";
    private static final String CLAUSE_NEGATION_MUTANT = "Clause negation mutants";
    private static final String OPERATOR_AND_MUTANT = "Operator AND mutants";
    private static final String OPERATOR_OR_MUTANT = "Operator OR mutants";
    private static final int OPERATOR_COUNT = 6;
    private ModelMutaLog model;
    private JPanel buttons, boxes;
    private JCheckBox literalOmission, literalNegation, clauseOmission, clauseNegation, operatorAnd, operatorOr;
    private JButton ok, cancel;

    public ViewMutantsConfiguration(ModelMutaLog model) {
        super();
        this.model = model;
        setLayout(new BorderLayout());
        setSize(D_WIDTH, D_HEIGHT);
        boxes = new JPanel(new GridLayout(OPERATOR_COUNT, 1));
        buttons = new JPanel();
        ok = new JButton(OK_TEXT);
        cancel = new JButton(CANCEL_TEXT);
        cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        buttons.add(ok);
        buttons.add(cancel);

        literalOmission = new JCheckBox(LITERAL_OMISSION_MUTANT);
        literalOmission.setSelected(true);
        literalNegation = new JCheckBox(LITERAL_NEGATION_MUTANT);
        literalNegation.setSelected(true);
        clauseOmission = new JCheckBox(CLAUSE_OMISSION_MUTANT);
        clauseOmission.setSelected(true);
        clauseNegation = new JCheckBox(CLAUSE_NEGATION_MUTANT);
        clauseNegation.setSelected(true);
        operatorAnd = new JCheckBox(OPERATOR_AND_MUTANT);
        operatorAnd.setSelected(true);
        operatorOr = new JCheckBox(OPERATOR_OR_MUTANT);
        operatorOr.setSelected(true);
        boxes.add(literalOmission);
        boxes.add(literalNegation);
        boxes.add(clauseOmission);
        boxes.add(clauseNegation);
        boxes.add(operatorAnd);
        boxes.add(operatorOr);

        add(boxes, BorderLayout.CENTER);
        add(buttons, BorderLayout.SOUTH);
        setTitle(TITLE);
        setVisible(false);

    }

    public JCheckBox getLiteralOmission() {
        return literalOmission;
    }

    public JCheckBox getLiteralNegation() {
        return literalNegation;
    }

    public JCheckBox getClauseOmission() {
        return clauseOmission;
    }

    public JCheckBox getClauseNegation() {
        return clauseNegation;
    }

    public JCheckBox getOperatorAnd() {
        return operatorAnd;
    }

    public JCheckBox getOperatorOr() {
        return operatorOr;
    }

    public JButton getOk() {
        return ok;
    }

    @Override
    public void update(Observable o, final Object arg) {
    }
}
