/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui.views;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import mutalog.core.ModelMutaLog;

public class ViewToolBar extends JToolBar implements Observer {

    private static final String LOAD_FORMULA = "Load a CNF formula";
    private static final String LOAD_TEST_SUITE = "Load a test suite";
    private static final String QUIT = "Quit";
    public static final String COMPUTE_MUT_SCORE = "Evaluate the mutation score";
    public static final String STOP = "Stop the execution";
    private JButton loadFormula, loadTestSuite, quit, coverage, stop;
    private ImageIcon loadFormulaIcon, loadTestSuiteIcon, quitIcon,
            stopIcon, coverageIcon;
    private final URL urlLoadFormula = getClass().getResource("icons/load_formula.png");
    private final URL urlLoadTestSuite = getClass().getResource("icons/load_testsuite.png");
    private final URL urlQuit = getClass().getResource("icons/exit.png");
    private final URL urlCoverage = getClass().getResource("icons/coverage.png");
    private final URL urlStop = getClass().getResource("icons/stop.png");
    private ModelMutaLog model;

    public ViewToolBar(ModelMutaLog model) {
        super();
        this.model = model;
        model.addObserver(this);
        setFloatable(false);
        setBorderPainted(false);
        loadFormulaIcon = new ImageIcon(urlLoadFormula);
        loadTestSuiteIcon = new ImageIcon(urlLoadTestSuite);
        quitIcon = new ImageIcon(urlQuit);
        coverageIcon = new ImageIcon(urlCoverage);
        stopIcon = new ImageIcon(urlStop);

        loadFormula = new JButton(loadFormulaIcon);
        loadFormula.setToolTipText(LOAD_FORMULA);
        loadFormula.setFocusPainted(false);

        loadTestSuite = new JButton(loadTestSuiteIcon);
        loadTestSuite.setToolTipText(LOAD_TEST_SUITE);
        loadTestSuite.setFocusPainted(false);

        quit = new JButton(quitIcon);
        quit.setToolTipText(QUIT);
        quit.setFocusPainted(false);

        coverage = new JButton(coverageIcon);
        coverage.setToolTipText(COMPUTE_MUT_SCORE);
        coverage.setFocusPainted(false);

        stop = new JButton(stopIcon);
        stop.setToolTipText(STOP);
        stop.setFocusPainted(false);


        add(loadFormula);
        add(loadTestSuite);
        add(quit);
        addSeparator();
        add(coverage);
        add(stop);
        loadTestSuite.setEnabled(model.getFormula() != null);
        coverage.setEnabled(model.getTestSuite() != null);
        stop.setEnabled(model.isRunning());

    }

    public JButton getLoadFormula() {
        return loadFormula;
    }

    public JButton getLoadTestSuite() {
        return loadTestSuite;
    }

    public JButton getQuit() {
        return quit;
    }

    public JButton getCoverage() {
        return coverage;
    }

    public JButton getStop() {
        return stop;
    }

    @Override
    public void update(Observable o, Object arg) {
        loadTestSuite.setEnabled(model.getFormula() != null);
        coverage.setEnabled(model.getTestSuite() != null);
        stop.setEnabled(model.isRunning());

    }
}
