/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 12/12/13
 * Copyright 2013 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mutalog.gui.views.controllers;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import mutalog.core.ModelMutaLog;
import mutalog.gui.views.ViewMutaLog;

public class ControllerLoadFormula extends AbstractAction {

    private ModelMutaLog model;
    private ViewMutaLog view;

    public ControllerLoadFormula(ModelMutaLog model, ViewMutaLog view) {
        this.model = model;
        this.view = view;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File selected = view.displayFormulaChooser();
        if (selected != null) {
            final String formulaPath = selected.getPath();
            final Thread t = new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        model.parseCNFFormula(formulaPath);
                    } catch (Exception ex) {
                        Logger.getLogger(ControllerLoadFormula.class.getName()).log(Level.SEVERE, null, ex);
                    }

                }
            });
            t.start();
        }
    }
}
