/*
 * Decompiled with CFR 0.152.
 */
package mutalog;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

public class CommandLineParser {
    private JCommander jCommander;
    private Mutation commandMutation;
    private String[] args;
    public static final String MUTATION = "mutation_score";

    public CommandLineParser(String[] args, String programName) {
        this.args = args;
        this.commandMutation = new Mutation();
        this.jCommander = new JCommander();
        this.jCommander.addCommand(MUTATION, this.commandMutation);
        this.jCommander.setProgramName("java -jar " + programName + ".jar");
    }

    public Mutation getCommandMutation() {
        return this.commandMutation;
    }

    public void parseArgs() {
        this.jCommander.parse(this.args);
    }

    public String getCommandName() {
        return this.jCommander.getParsedCommand();
    }

    public void printUsage() {
        this.jCommander.usage();
    }

    @Parameters(commandDescription="Evaluate the mutation score of the test suite")
    public class Mutation {
        @Parameter(names={"-f"}, description="The CNF formula file (.dimacs)", required=true)
        public String fmFile;
        @Parameter(names={"-ts"}, description="The test suite file", required=true)
        public String testFile;
        @Parameter(names={"-lo"}, description="Use literal omission mutants")
        public boolean lo = false;
        @Parameter(names={"-ln"}, description="Use literal negation mutants")
        public boolean ln = false;
        @Parameter(names={"-co"}, description="Use clause omission mutants")
        public boolean co = false;
        @Parameter(names={"-cn"}, description="Use clause negation mutants")
        public boolean cn = false;
        @Parameter(names={"-and"}, description="Use operator AND mutants")
        public boolean and = false;
        @Parameter(names={"-or"}, description="Use operator OR mutants")
        public boolean or = false;
    }
}

