/*
 * Decompiled with CFR 0.152.
 */
package mutalog.core;

import java.util.ArrayList;
import java.util.List;
import mutalog.core.Clause;
import mutalog.core.Literal;
import mutalog.core.Mutant;

public class CNFFormula {
    protected List<Clause> clauses = new ArrayList<Clause>();
    protected int nVars;

    public CNFFormula() {
    }

    public CNFFormula(CNFFormula formula) {
        this();
        for (Clause c : formula.getClauses()) {
            this.clauses.add(new Clause(c));
        }
    }

    public int nClauses() {
        return this.clauses.size();
    }

    public int nVars() {
        return this.nVars;
    }

    public void setnVars(int nVars) {
        this.nVars = nVars;
    }

    public Clause getIClause(int index) {
        return this.clauses.get(index);
    }

    public void removeIClause(int index) {
        this.clauses.remove(index);
    }

    public void negtateIClause(int index) {
        Clause c = this.clauses.get(index);
        for (Literal l : c.getLiterals()) {
            Clause cl = new Clause();
            cl.addLiteral(l);
            cl.getILiteral(0).negate();
            this.clauses.add(cl);
        }
        this.clauses.remove(index);
    }

    public List<Clause> getClauses() {
        return this.clauses;
    }

    public void addClause(Clause c) {
        this.clauses.add(c);
    }

    public List<Mutant> getLiteralOmissionMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = 0;
        for (Clause c : this.clauses) {
            int nLiteral = 0;
            for (Literal l : c.getLiterals()) {
                Mutant mutant = new Mutant(this, "(LIT. OM.)");
                mutant.getIClause(nClause).removeLiteral(nLiteral);
                if (mutant.getIClause(nClause).isEmpty()) {
                    mutant.removeIClause(nClause);
                }
                ++nLiteral;
                mutants.add(mutant);
            }
            ++nClause;
        }
        return mutants;
    }

    public List<Mutant> getLiteralNegationMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = 0;
        for (Clause c : this.clauses) {
            int nLiteral = 0;
            for (Literal l : c.getLiterals()) {
                Mutant mutant = new Mutant(this, "(LIT. NEG.)");
                mutant.getIClause(nClause).getILiteral(nLiteral).negate();
                ++nLiteral;
                mutants.add(mutant);
            }
            ++nClause;
        }
        return mutants;
    }

    public List<Mutant> getClauseOmissionMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = 0;
        for (Clause c : this.clauses) {
            Mutant mutant = new Mutant(this, "(CLAUSE OM.)");
            mutant.removeIClause(nClause);
            mutants.add(mutant);
            ++nClause;
        }
        return mutants;
    }

    public List<Mutant> getClauseNegationMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = 0;
        for (Clause c : this.clauses) {
            Mutant mutant = new Mutant(this, "(CLAUSE NEG.)");
            mutant.negtateIClause(nClause);
            mutants.add(mutant);
            ++nClause;
        }
        return mutants;
    }

    public List<Mutant> getOperatorReferenceAndMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = this.clauses.size();
        for (int i = 0; i < nClause - 1; ++i) {
            Clause c = new Clause();
            for (Literal l : this.clauses.get(i).getLiterals()) {
                c.addLiteral(l);
            }
            for (Literal l : this.clauses.get(i + 1).getLiterals()) {
                c.addLiteral(l);
            }
            Mutant mutant = new Mutant(this, "(OP. AND)");
            mutant.removeIClause(i);
            mutant.removeIClause(i);
            mutant.addClause(c);
            mutants.add(mutant);
        }
        return mutants;
    }

    public List<Mutant> getOperatorReferenceOrMutants() {
        ArrayList<Mutant> mutants = new ArrayList<Mutant>();
        int nClause = 0;
        for (Clause c : this.clauses) {
            if (c.nLiterals() > 1) {
                int nLiteral = c.nLiterals();
                for (int i = 0; i < nLiteral - 1; ++i) {
                    int j;
                    Mutant mutant = new Mutant(this, "(OP. OR)");
                    mutant.removeIClause(nClause);
                    Clause c1 = new Clause();
                    Clause c2 = new Clause();
                    for (j = 0; j <= i; ++j) {
                        c1.addLiteral(c.getILiteral(j));
                    }
                    for (j = i + 1; j < nLiteral; ++j) {
                        c2.addLiteral(c.getILiteral(j));
                    }
                    mutant.addClause(c1);
                    mutant.addClause(c2);
                    mutants.add(mutant);
                }
            }
            ++nClause;
        }
        return mutants;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (int i = 0; i < this.clauses.size(); ++i) {
            Clause c = this.clauses.get(i);
            if (n++ != 0) {
                sb.append("\n");
            }
            sb.append(c.toString());
        }
        return sb.toString();
    }
}

