/*
 * Decompiled with CFR 0.152.
 */
package mutalog.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mutalog.core.ModelMutaLog;

public class ViewFormula
extends JPanel
implements Observer {
    private static final String TITLE = "CNF Formula";
    private static final String INFO_TITLE = "Information";
    private static final String CLAUSES_TITLE = "Clauses";
    public static final String VARS = "Number of variables:";
    public static final String CLAUSES = "Number of clauses:";
    public static final String DEAD = "Number of dead features:";
    private JPanel info;
    private JPanel formula;
    private JLabel varsLabel;
    private JLabel vars;
    private JLabel clausesLabel;
    private JLabel clauses;
    private JTextArea area;
    private JScrollPane pane;
    private ModelMutaLog model;

    public ViewFormula(ModelMutaLog model) {
        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        this.info = new JPanel(new GridBagLayout());
        this.info.setBorder(BorderFactory.createTitledBorder(INFO_TITLE));
        this.formula = new JPanel(new GridLayout(1, 1));
        this.formula.setBorder(BorderFactory.createTitledBorder(CLAUSES_TITLE));
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
        this.varsLabel = new JLabel(VARS);
        this.vars = new JLabel("-", 2);
        this.clausesLabel = new JLabel(CLAUSES);
        this.clauses = new JLabel("-", 2);
        GridBagConstraints c = new GridBagConstraints();
        Insets i = new Insets(20, 15, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = i;
        c.anchor = 768;
        this.info.add((Component)this.varsLabel, c);
        i = new Insets(20, 15, 0, 0);
        c.gridx = 1;
        c.insets = i;
        c.anchor = 512;
        this.info.add((Component)this.vars, c);
        c.gridx = 2;
        c.anchor = 768;
        this.info.add((Component)this.clausesLabel, c);
        c.gridx = 3;
        c.anchor = 512;
        this.info.add((Component)this.clauses, c);
        this.area = new JTextArea();
        this.area.setEditable(false);
        this.pane = new JScrollPane(this.area);
        this.pane.setPreferredSize(new Dimension(100, 200));
        this.formula.add(this.pane);
        this.add((Component)this.info, "North");
        this.add((Component)this.formula, "Center");
    }

    @Override
    public void update(Observable o, Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (ViewFormula.this.model.getFormula() != null) {
                    ViewFormula.this.vars.setText("" + ViewFormula.this.model.getFormula().nVars());
                    ViewFormula.this.clauses.setText("" + ViewFormula.this.model.getFormula().nClauses());
                    ViewFormula.this.area.setText(ViewFormula.this.model.getFormula().toString());
                    ViewFormula.this.validateTree();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

