/*
 * Decompiled with CFR 0.152.
 */
package mutalog.gui.views;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import mutalog.core.ModelMutaLog;

public class ViewToolBar
extends JToolBar
implements Observer {
    private static final String LOAD_FORMULA = "Load a CNF formula";
    private static final String LOAD_TEST_SUITE = "Load a test suite";
    private static final String QUIT = "Quit";
    public static final String COMPUTE_MUT_SCORE = "Evaluate the mutation score";
    public static final String STOP = "Stop the execution";
    private JButton loadFormula;
    private JButton loadTestSuite;
    private JButton quit;
    private JButton coverage;
    private JButton stop;
    private ImageIcon loadFormulaIcon;
    private ImageIcon loadTestSuiteIcon;
    private ImageIcon quitIcon;
    private ImageIcon stopIcon;
    private ImageIcon coverageIcon;
    private final URL urlLoadFormula = this.getClass().getResource("icons/load_formula.png");
    private final URL urlLoadTestSuite = this.getClass().getResource("icons/load_testsuite.png");
    private final URL urlQuit = this.getClass().getResource("icons/exit.png");
    private final URL urlCoverage = this.getClass().getResource("icons/coverage.png");
    private final URL urlStop = this.getClass().getResource("icons/stop.png");
    private ModelMutaLog model;

    public ViewToolBar(ModelMutaLog model) {
        this.model = model;
        model.addObserver(this);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.loadFormulaIcon = new ImageIcon(this.urlLoadFormula);
        this.loadTestSuiteIcon = new ImageIcon(this.urlLoadTestSuite);
        this.quitIcon = new ImageIcon(this.urlQuit);
        this.coverageIcon = new ImageIcon(this.urlCoverage);
        this.stopIcon = new ImageIcon(this.urlStop);
        this.loadFormula = new JButton(this.loadFormulaIcon);
        this.loadFormula.setToolTipText(LOAD_FORMULA);
        this.loadFormula.setFocusPainted(false);
        this.loadTestSuite = new JButton(this.loadTestSuiteIcon);
        this.loadTestSuite.setToolTipText(LOAD_TEST_SUITE);
        this.loadTestSuite.setFocusPainted(false);
        this.quit = new JButton(this.quitIcon);
        this.quit.setToolTipText(QUIT);
        this.quit.setFocusPainted(false);
        this.coverage = new JButton(this.coverageIcon);
        this.coverage.setToolTipText(COMPUTE_MUT_SCORE);
        this.coverage.setFocusPainted(false);
        this.stop = new JButton(this.stopIcon);
        this.stop.setToolTipText(STOP);
        this.stop.setFocusPainted(false);
        this.add(this.loadFormula);
        this.add(this.loadTestSuite);
        this.add(this.quit);
        this.addSeparator();
        this.add(this.coverage);
        this.add(this.stop);
        this.loadTestSuite.setEnabled(model.getFormula() != null);
        this.coverage.setEnabled(model.getTestSuite() != null);
        this.stop.setEnabled(model.isRunning());
    }

    public JButton getLoadFormula() {
        return this.loadFormula;
    }

    public JButton getLoadTestSuite() {
        return this.loadTestSuite;
    }

    public JButton getQuit() {
        return this.quit;
    }

    public JButton getCoverage() {
        return this.coverage;
    }

    public JButton getStop() {
        return this.stop;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.loadTestSuite.setEnabled(this.model.getFormula() != null);
        this.coverage.setEnabled(this.model.getTestSuite() != null);
        this.stop.setEnabled(this.model.isRunning());
    }
}

