/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private ISolverService solverService;

    public LearnedTracing(String string) {
        this.filename = string;
    }

    @Override
    public void solutionFound(int[] nArray) {
        this.trace();
    }

    @Override
    public void restarting() {
        this.trace();
    }

    private void trace() {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append(".dat").toString()));
            IVec<? extends IConstr> iVec = this.solverService.getLearnedConstraints();
            int n = iVec.size();
            for (int i = 0; i < n; ++i) {
                printStream.printf("%d %g\n", new Integer(i), new Double(iVec.get(i).getActivity()));
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.solverService = iSolverService;
    }

    @Override
    public void cleaning() {
        this.trace();
    }
}

