/*
 * Decompiled with CFR 0.152.
 */
package pledge.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ModelIterator;
import pledge.core.Product;
import pledge.core.TSet;
import pledge.core.Util;
import pledge.core.techniques.generation.EvolutionaryAlgorithm1Plus1;
import pledge.core.techniques.generation.GenerationTechnique;
import pledge.core.techniques.prioritization.PrioritizationTechnique;
import pledge.core.techniques.prioritization.SimilarityGreedy;
import pledge.core.techniques.prioritization.SimilarityNearOptimal;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.fm.XMLFeatureModel;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;

public class ModelPLEDGE
extends Observable {
    private static final int SAT_TIMEOUT = 1000;
    private static final int ITERATOR_TIMEOUT = 150000;
    private static final String solverName = "MiniSAT";
    public static final String OR = "   OR   ";
    public static final String NOT = "! ";
    private static final IOrder order = new RandomWalkDecorator(new VarOrderHeap((IPhaseSelectionStrategy)new RandomLiteralSelectionStrategy()), 1.0);
    private static final String GLOBAL_ACTION_LOAD_FM = "Loading the Feature Model";
    private static final String GLOBAL_ACTION_LOAD_PRODUCTS = "Loading Products";
    private static final String GLOBAL_ACTION_GENERATING_PRODUCTS = "Generating products";
    private static final String GLOBAL_ACTION_PRIORITIZING_PRODUCTS = "Prioritizing products";
    private static final String GLOBAL_ACTION_COVERAGE = "Computing the coverage";
    private static final String CURRENT_ACTION_LOAD_CONSTRAINTS = "Loading the constraints...";
    private static final String CURRENT_ACTION_EXTRACT_FEATURES = "Extracting the features...";
    private static final String CURRENT_ACTION_EXTRACT_CONSTRAINTS = "Extracting the constraints...";
    private static final String CURRENT_ACTION_FINDING_CORE_DEAD_FEATURES = "Finding core and dead features...";
    private static final String CURRENT_ACTION_MODEL_PAIRS = "Computing the valid pairs of the model...";
    private static final String CURRENT_ACTION_PRODUCT_PAIRS = "Computing the pairs covered by the products...";
    private static final String CORE_FEATURE = "Core";
    private static final String DEAD_FEATURE = "Dead";
    private static final String FREE_FEATURE = "Free";
    private Solver solver = null;
    private ISolver solverIterator = null;
    private List<Integer> featuresIntList = new ArrayList<Integer>();
    private List<String> featuresList = new ArrayList<String>();
    private Map<String, Integer> namesToFeaturesInt = new HashMap<String, Integer>();
    private List<String> featureModelConstraints = new ArrayList<String>();
    private List<String> featureModelConstraintsString = new ArrayList<String>();
    private FeatureModelFormat featureModelFormat;
    private String featureModelName;
    private boolean running = false;
    private boolean indeterminate = true;
    private String globalAction;
    private String currentAction;
    private List<String> coreFeatures = new ArrayList<String>();
    private List<String> deadFeatures = new ArrayList<String>();
    private int progress = 0;
    private List<Product> products = null;
    private List<GenerationTechnique> generationTechniques = new ArrayList<GenerationTechnique>();
    private GenerationTechnique generationTechnique;
    private List<PrioritizationTechnique> prioritizationTechniques;
    private PrioritizationTechnique prioritizationTechnique;
    private long generationTimeMSAllowed = 60000L;
    private int nbProductsToGenerate = 10;
    private String fmPath;
    private int currentConstraint = -1;

    public ModelPLEDGE() {
        this.generationTechniques.add(new EvolutionaryAlgorithm1Plus1());
        this.generationTechnique = this.generationTechniques.get(0);
        this.prioritizationTechniques = new ArrayList<PrioritizationTechnique>();
        this.prioritizationTechniques.add(new SimilarityGreedy());
        this.prioritizationTechniques.add(new SimilarityNearOptimal());
        this.prioritizationTechnique = this.prioritizationTechniques.get(0);
    }

    public FeatureModelFormat getFeatureModelFormat() {
        return this.featureModelFormat;
    }

    public String getFeatureModelName() {
        return this.featureModelName;
    }

    public List<Integer> getFeaturesIntList() {
        return this.featuresIntList;
    }

    public List<String> getFeaturesList() {
        return this.featuresList;
    }

    public Map<String, Integer> getNamesToFeaturesInt() {
        return this.namesToFeaturesInt;
    }

    public List<String> getFeatureModelConstraints() {
        return this.featureModelConstraints;
    }

    public List<String> getFeatureModelConstraintsString() {
        return this.featureModelConstraintsString;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public boolean isRunning() {
        return this.running;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public long getGenerationTimeMSAllowed() {
        return this.generationTimeMSAllowed;
    }

    public void setGenerationTimeMSAllowed(long generationTimeMSAllowed) {
        this.generationTimeMSAllowed = generationTimeMSAllowed;
        this.setChanged();
        this.notifyObservers();
    }

    public int getNbProductsToGenerate() {
        return this.nbProductsToGenerate;
    }

    public void setNbProductsToGenerate(int nbProductsToGenerate) {
        this.nbProductsToGenerate = nbProductsToGenerate;
        this.setChanged();
        this.notifyObservers();
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (!running) {
            this.indeterminate = true;
        }
        this.progress = 0;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.setChanged();
        this.notifyObservers();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.setChanged();
        this.notifyObservers();
    }

    public ISolver getSolverIterator() {
        return this.solverIterator;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(String currentAction) {
        this.currentAction = currentAction;
        this.setChanged();
        this.notifyObservers();
    }

    public String getGlobalAction() {
        return this.globalAction;
    }

    public void setGlobalAction(String globalAction) {
        this.globalAction = globalAction;
        this.setChanged();
        this.notifyObservers();
    }

    private void clean() {
        this.featuresIntList.clear();
        this.featuresList.clear();
        this.namesToFeaturesInt.clear();
        this.featureModelConstraints.clear();
        this.featureModelConstraintsString.clear();
        this.coreFeatures.clear();
        this.deadFeatures.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public List<String> getCoreFeatures() {
        return this.coreFeatures;
    }

    public List<String> getDeadFeatures() {
        return this.deadFeatures;
    }

    public GenerationTechnique getGenerationTechnique() {
        return this.generationTechnique;
    }

    public void SetGenerationTechniqueByName(String name) {
        for (GenerationTechnique gt : this.generationTechniques) {
            if (!gt.getName().equals(name)) continue;
            this.generationTechnique = gt;
            break;
        }
    }

    public List<GenerationTechnique> getGenerationTechniques() {
        return this.generationTechniques;
    }

    public PrioritizationTechnique getPrioritizationTechnique() {
        return this.prioritizationTechnique;
    }

    public void SetPrioritizationTechniqueByName(String name) {
        for (PrioritizationTechnique pt : this.prioritizationTechniques) {
            if (!pt.getName().equals(name)) continue;
            this.prioritizationTechnique = pt;
            break;
        }
    }

    public List<PrioritizationTechnique> getPrioritizationTechniques() {
        return this.prioritizationTechniques;
    }

    public void loadFeatureModel(String filePath, FeatureModelFormat format) throws Exception {
        this.setRunning(true);
        this.setIndeterminate(true);
        this.setGlobalAction(GLOBAL_ACTION_LOAD_FM);
        this.setCurrentAction(CURRENT_ACTION_LOAD_CONSTRAINTS);
        this.featureModelFormat = format;
        this.clean();
        this.featureModelName = new File(filePath).getName();
        this.featureModelName = this.featureModelName.substring(0, this.featureModelName.lastIndexOf("."));
        this.products = null;
        this.fmPath = filePath;
        switch (format) {
            case SPLOT: {
                XMLFeatureModel fm = new XMLFeatureModel(filePath, 10);
                fm.loadModel();
                FMReasoningWithSAT reasonerSAT = new FMReasoningWithSAT(solverName, fm, 1000);
                reasonerSAT.init();
                this.solver = (Solver)reasonerSAT.getSolver();
                String[] features = reasonerSAT.getVarIndex2NameMap();
                for (int i = 0; i < features.length; ++i) {
                    String featureName = features[i];
                    this.featuresList.add(featureName);
                    int n = i + 1;
                    this.featuresIntList.add(n);
                    this.namesToFeaturesInt.put(featureName, n);
                }
                break;
            }
            case DIMACS: {
                String line;
                ISolver dimacsSolver = SolverFactory.instance().createSolverByName(solverName);
                DimacsReader dr = new DimacsReader(dimacsSolver);
                dr.parseInstance((Reader)new FileReader(filePath));
                this.solver = (Solver)dimacsSolver;
                BufferedReader in = new BufferedReader(new FileReader(filePath));
                int n = 0;
                while ((line = in.readLine()) != null && line.startsWith("c")) {
                    StringTokenizer st = new StringTokenizer(line.trim(), " ");
                    st.nextToken();
                    String sFeature = st.nextToken().replace('$', ' ').trim();
                    int feature = Integer.parseInt(sFeature);
                    if (++n != feature) {
                        throw new Exception("Incorrect dimacs file, missing feature number " + n + " ?");
                    }
                    String featureName = st.nextToken();
                    this.featuresIntList.add(feature);
                    this.featuresList.add(featureName);
                    this.namesToFeaturesInt.put(featureName, feature);
                }
                in.close();
            }
        }
        this.setCurrentAction(CURRENT_ACTION_EXTRACT_FEATURES);
        this.setIndeterminate(false);
        this.setProgress(0);
        int n = 1;
        int featuresCount = this.featuresIntList.size();
        while (n <= featuresCount) {
            this.featuresIntList.add(-n);
            this.setProgress((int)((double)(++n) / (double)featuresCount * 100.0));
        }
        if (this.solver != null) {
            this.solver.setTimeout(1000);
        }
        this.solver.setOrder(order);
        this.solverIterator = new ModelIterator((ISolver)this.solver);
        this.solverIterator.setTimeoutMs(150000L);
        this.setCurrentAction(CURRENT_ACTION_EXTRACT_CONSTRAINTS);
        this.setProgress(0);
        int nConstraints = 0;
        switch (format) {
            case SPLOT: {
                this.setIndeterminate(true);
                XMLFeatureModel fm = new XMLFeatureModel(filePath, 10);
                fm.loadModel();
                FMReasoningWithSAT reasonerSAT = new FMReasoningWithSAT(solverName, fm, 1000);
                reasonerSAT.init();
                CNFFormula formula = fm.FM2CNF();
                nConstraints = formula.getClauses().size();
                this.setIndeterminate(false);
                int j = 0;
                for (CNFClause clause : formula.getClauses()) {
                    String cons = "";
                    for (int i = 0; i < clause.getLiterals().size(); ++i) {
                        int signal = clause.getLiterals().get(i).isPositive() ? 1 : -1;
                        int varID = reasonerSAT.getVariableIndex(clause.getLiterals().get(i).getVariable().getID());
                        String f = this.featuresList.get(varID - 1);
                        if (signal < 0) {
                            f = NOT + f;
                        }
                        cons = cons.equals("") ? cons + f : cons + OR + f;
                    }
                    this.featureModelConstraints.add(cons);
                    this.featureModelConstraintsString.add(cons);
                    this.setProgress((int)((double)(j + 1) / (double)nConstraints * 100.0));
                    ++j;
                }
                break;
            }
            case DIMACS: {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(filePath));
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith("p")) continue;
                    StringTokenizer st = new StringTokenizer(line.trim(), " ");
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    nConstraints = Integer.parseInt(st.nextToken());
                    break;
                }
                in.close();
                int i = 0;
                in = new BufferedReader(new FileReader(filePath));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("c") || line.startsWith("p")) continue;
                    String cons = "";
                    StringTokenizer st = new StringTokenizer(line.trim(), " ");
                    while (st.hasMoreTokens()) {
                        int f = Integer.parseInt(st.nextToken());
                        if (f == 0) continue;
                        if (cons.equals("")) {
                            if (f > 0) {
                                cons = cons + this.featuresList.get(f - 1);
                                continue;
                            }
                            cons = cons + NOT + this.featuresList.get(-f - 1);
                            continue;
                        }
                        cons = cons + OR;
                        if (f > 0) {
                            cons = cons + this.featuresList.get(f - 1);
                            continue;
                        }
                        cons = cons + NOT + this.featuresList.get(-f - 1);
                    }
                    this.featureModelConstraints.add(cons);
                    this.featureModelConstraintsString.add(cons);
                    this.setProgress((int)((double)(i + 1) / (double)nConstraints * 100.0));
                    ++i;
                }
                in.close();
            }
        }
        this.setCurrentAction(CURRENT_ACTION_FINDING_CORE_DEAD_FEATURES);
        this.setProgress(0);
        n = 0;
        VecInt vector = new VecInt();
        for (String feature : this.featuresList) {
            int f = this.namesToFeaturesInt.get(feature);
            vector.clear();
            vector.push(-f);
            if (!this.solver.isSatisfiable((IVecInt)vector)) {
                this.coreFeatures.add(feature);
            }
            vector.clear();
            vector.push(f);
            if (!this.solver.isSatisfiable((IVecInt)vector)) {
                this.deadFeatures.add(feature);
            }
            this.setProgress((int)((double)(++n) / (double)featuresCount * 100.0));
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers(this.featureModelConstraints);
    }

    public void removeConstraint(int i) {
        this.featureModelConstraintsString.remove(i);
        this.setChanged();
        this.notifyObservers(this.featureModelConstraints);
    }

    public void generateProducts() throws Exception {
        this.setRunning(true);
        this.setIndeterminate(false);
        this.setGlobalAction(GLOBAL_ACTION_GENERATING_PRODUCTS);
        this.products = this.generationTechnique.generateProducts(this, this.nbProductsToGenerate, this.generationTimeMSAllowed, this.prioritizationTechnique);
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers();
    }

    public void prioritizeProducts() throws Exception {
        this.setRunning(true);
        this.setIndeterminate(false);
        this.setGlobalAction(GLOBAL_ACTION_PRIORITIZING_PRODUCTS);
        this.products = this.prioritizationTechnique.prioritize(this, this.products);
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers();
    }

    private Set<TSet> computeValidPairs() throws TimeoutException {
        HashSet<TSet> pairs = new HashSet<TSet>();
        ArrayList<Integer> extendedFeatures = new ArrayList<Integer>(this.featuresIntList.size() * 2);
        for (Integer i : this.featuresIntList) {
            extendedFeatures.add(i);
            extendedFeatures.add(-i.intValue());
        }
        int size = extendedFeatures.size();
        Util.nCk(size, 2, pairs, extendedFeatures, true, this.solver);
        return pairs;
    }

    public String getPairwiseCoverage() throws TimeoutException {
        this.setRunning(true);
        this.setIndeterminate(false);
        this.setGlobalAction(GLOBAL_ACTION_COVERAGE);
        this.setCurrentAction(CURRENT_ACTION_PRODUCT_PAIRS);
        HashSet<TSet> productsPairs = new HashSet<TSet>();
        int i = 0;
        for (Product p : this.products) {
            this.setCurrentAction("Computing the pairs covered by the products... product " + i);
            productsPairs.addAll(p.getCoveredPairs());
            this.setProgress((int)((double)i / (double)this.products.size() * 100.0));
            ++i;
        }
        int d1 = productsPairs.size();
        int d2 = 0;
        double cov = 0.0;
        if (this.solver != null) {
            this.setIndeterminate(true);
            this.setCurrentAction(CURRENT_ACTION_MODEL_PAIRS);
            d2 = this.computeValidPairs().size();
            cov = (double)d1 / (double)d2 * 100.0;
        } else {
            cov = d1;
        }
        this.setRunning(false);
        if (this.solver != null) {
            return "Number of valid pairs of the model: " + d2 + "\nNumber of pairs covered by the products: " + d1 + "\n\nCoverage: " + new DecimalFormat("#.##").format(cov) + "%";
        }
        return "Number of pairs covered by the products: " + d1;
    }

    public String getFeatureType(String feature) {
        if (this.coreFeatures.contains(feature)) {
            return CORE_FEATURE;
        }
        if (this.deadFeatures.contains(feature)) {
            return DEAD_FEATURE;
        }
        return FREE_FEATURE;
    }

    private Product toProduct(int[] vector) {
        Product product = new Product();
        for (int i : vector) {
            product.add(i);
        }
        return product;
    }

    public List<Product> getUnpredictableProducts(int count) {
        ArrayList<Product> products = new ArrayList<Product>(count);
        while (products.size() < count) {
            try {
                if (this.solverIterator.isSatisfiable()) {
                    Product product = this.toProduct(this.solverIterator.model());
                    if (products.contains(product)) continue;
                    products.add(product);
                    continue;
                }
                switch (this.featureModelFormat) {
                    case SPLOT: {
                        XMLFeatureModel fm = new XMLFeatureModel(this.fmPath, 10);
                        fm.loadModel();
                        FMReasoningWithSAT reasonerSAT = new FMReasoningWithSAT(solverName, fm, 1000);
                        reasonerSAT.init();
                        this.solver = (Solver)reasonerSAT.getSolver();
                        break;
                    }
                    case DIMACS: {
                        ISolver dimacsSolver = SolverFactory.instance().createSolverByName(solverName);
                        DimacsReader dr = new DimacsReader(dimacsSolver);
                        dr.parseInstance((Reader)new FileReader(this.fmPath));
                        this.solver = (Solver)dimacsSolver;
                    }
                }
                this.solver.setTimeout(1000);
                this.solver.setOrder(order);
                this.solverIterator = new ModelIterator((ISolver)this.solver);
                this.solverIterator.setTimeoutMs(150000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return products;
    }

    public void saveProducts(String outFile) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        int featuresCount = this.featuresList.size();
        for (int i = 1; i <= featuresCount; ++i) {
            out.write(i + "->" + this.featuresList.get(i - 1));
            out.newLine();
        }
        for (Product product : this.products) {
            int done = 0;
            for (Integer feature : product) {
                out.write("" + feature);
                if (done < product.size()) {
                    out.write(";");
                }
                ++done;
            }
            out.newLine();
        }
        out.close();
    }

    public void loadProducts(String inFile) throws Exception {
        String line;
        this.setRunning(true);
        this.setIndeterminate(true);
        this.setGlobalAction(GLOBAL_ACTION_LOAD_PRODUCTS);
        this.solver = null;
        this.solverIterator = null;
        this.featuresIntList = new ArrayList<Integer>();
        this.featuresList = new ArrayList<String>();
        this.namesToFeaturesInt = new HashMap<String, Integer>();
        this.featureModelConstraints = new ArrayList<String>();
        this.featureModelConstraintsString = new ArrayList<String>();
        this.coreFeatures = new ArrayList<String>();
        this.deadFeatures = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        this.products = new ArrayList<Product>();
        while ((line = in.readLine()) != null) {
            if (line.contains(">")) continue;
            Product p = new Product();
            this.setCurrentAction("Extracting product number" + this.products.size());
            StringTokenizer st = new StringTokenizer(line, ";");
            while (st.hasMoreTokens()) {
                p.add(Integer.parseInt(st.nextToken()));
            }
            this.products.add(p);
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void loadProductsFM(String inFile) throws Exception {
        String line;
        this.setRunning(true);
        this.setIndeterminate(true);
        this.setGlobalAction(GLOBAL_ACTION_LOAD_PRODUCTS);
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        this.products = new ArrayList<Product>();
        while ((line = in.readLine()) != null) {
            if (line.contains(">")) continue;
            Product p = new Product();
            this.setCurrentAction("Extracting product number" + this.products.size());
            StringTokenizer st = new StringTokenizer(line, ";");
            while (st.hasMoreTokens()) {
                p.add(Integer.parseInt(st.nextToken()));
            }
            this.products.add(p);
        }
        this.setRunning(false);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void quit() {
        System.exit(0);
    }

    public int getCurrentConstraint() {
        return this.currentConstraint;
    }

    public void setCurrentConstraint(int currentConstraint) {
        this.currentConstraint = currentConstraint;
        this.setChanged();
        this.notifyObservers();
    }

    public static enum FeatureModelFormat {
        SPLOT,
        DIMACS;

    }
}

