/*
 * Decompiled with CFR 0.152.
 */
package pledge.core.techniques.generation;

import java.util.ArrayList;
import java.util.List;
import pledge.core.ModelPLEDGE;
import pledge.core.Product;
import pledge.core.techniques.DistancesUtil;
import pledge.core.techniques.prioritization.PrioritizationTechnique;

public class Individual
implements Comparable<Individual> {
    public static final int MUTATE_WORST = 0;
    public static final int MUTATE_BEST = 1;
    public static final int MUTATE_RANDOM = 2;
    private double fitness;
    private List<Product> products;
    private PrioritizationTechnique prioritizationTechnique;
    private ModelPLEDGE model;

    public Individual(ModelPLEDGE model, Individual other, PrioritizationTechnique prioritizationTechnique) {
        this.products = new ArrayList<Product>(other.products);
        this.fitness = -1.0;
        this.prioritizationTechnique = prioritizationTechnique;
        this.model = model;
    }

    public Individual(ModelPLEDGE model, List<Product> products, PrioritizationTechnique prioritizationTechnique) {
        this.products = products;
        this.prioritizationTechnique = prioritizationTechnique;
        this.model = model;
    }

    public void fitnessAndOrdering() throws Exception {
        this.products = this.prioritizationTechnique.prioritize(this.model, this.products);
        this.fitness = this.prioritizationTechnique.getFitnessSum();
    }

    public void fitness() {
        this.fitness = 0.0;
        int size = this.products.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (j <= i) continue;
                this.fitness += DistancesUtil.getJaccardDistance(this.products.get(i), this.products.get(j));
            }
        }
    }

    public double getFitness() {
        return this.fitness;
    }

    public int getSize() {
        return this.products.size();
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void mutate(int mutateType, ModelPLEDGE model) throws Exception {
        Product p;
        while (this.products.contains(p = model.getUnpredictableProducts(1).get(0))) {
        }
        switch (mutateType) {
            case 0: {
                this.products.set(this.products.size() - 1, p);
                break;
            }
            case 1: {
                this.products.set(0, p);
                break;
            }
            case 2: {
                int ind = (int)(Math.random() * (double)(this.products.size() - 2)) + 1;
                this.products.set(ind, p);
                break;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Individual other = (Individual)obj;
        return this.products == other.products || this.products != null && this.products.equals(other.products);
    }

    public String toString() {
        return "Individual{fitness=" + this.fitness + ", products=" + this.products + '}';
    }

    @Override
    public int compareTo(Individual o) {
        double tF = this.getFitness();
        double oF = o.getFitness();
        return Double.compare(oF, tF);
    }
}

