/*
 * Decompiled with CFR 0.152.
 */
package pledge.core.techniques.prioritization;

import java.util.ArrayList;
import java.util.List;
import pledge.core.ModelPLEDGE;
import pledge.core.Product;
import pledge.core.techniques.DistancesUtil;
import pledge.core.techniques.prioritization.PrioritizationTechnique;

public class SimilarityGreedy
implements PrioritizationTechnique {
    public static final String NAME = "Similarity / Greedy";
    private double fitnessSum;

    @Override
    public List<Product> prioritize(ModelPLEDGE model, List<Product> products) throws Exception {
        int size = products.size();
        ArrayList<Product> prioritizedProducts = new ArrayList<Product>(size);
        ArrayList<Product> productsCopy = new ArrayList<Product>(products);
        double[][] distancesMatrix = new double[size][size];
        this.fitnessSum = 0.0;
        double total = products.size() * (products.size() - 1) / 2;
        double done = 0.0;
        for (int i = 0; i < distancesMatrix.length; ++i) {
            for (int j = 0; j < distancesMatrix.length; ++j) {
                double dist;
                distancesMatrix[i][j] = -1.0;
                if (j <= i) continue;
                distancesMatrix[i][j] = dist = DistancesUtil.getJaccardDistance((Product)productsCopy.get(i), (Product)productsCopy.get(j));
                this.fitnessSum += dist;
                done += 1.0;
            }
        }
        while (!productsCopy.isEmpty()) {
            if (productsCopy.size() != 1) {
                double dmax = -1.0;
                int toAddIIndex = -1;
                int toAddJIndex = -1;
                for (int i = 0; i < distancesMatrix.length; ++i) {
                    for (int j = 0; j < distancesMatrix.length; ++j) {
                        if (j <= i || !(distancesMatrix[i][j] > dmax)) continue;
                        dmax = distancesMatrix[i][j];
                        toAddIIndex = i;
                        toAddJIndex = j;
                    }
                }
                Product pi = products.get(toAddIIndex);
                Product pj = products.get(toAddJIndex);
                prioritizedProducts.add(pi);
                prioritizedProducts.add(pj);
                productsCopy.remove(pi);
                productsCopy.remove(pj);
                for (int i = 0; i < distancesMatrix.length; ++i) {
                    distancesMatrix[toAddJIndex][i] = -1.0;
                    distancesMatrix[i][toAddJIndex] = -1.0;
                    distancesMatrix[i][toAddIIndex] = -1.0;
                    distancesMatrix[toAddIIndex][i] = -1.0;
                }
                continue;
            }
            prioritizedProducts.add((Product)productsCopy.get(0));
            productsCopy.clear();
        }
        return prioritizedProducts;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getFitnessSum() {
        return this.fitnessSum;
    }
}

