/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import pledge.core.ModelPLEDGE;
import pledge.gui.views.ViewPLEDGE;

public class ViewConfigurationGeneration
extends JDialog
implements Observer {
    private static final String CONFIG_GENERATION = "Generation parameters";
    private static final String NB_PRODUCTS = "Number of products to generate:";
    private static final String TIME = "Time in seconds allowed for the generation:";
    private static final String OK = "Ok";
    private static final int D_WIDTH = 500;
    private static final int D_HEIGHT = 150;
    private ModelPLEDGE model;
    private JLabel nbProductsLabel;
    private JLabel timeLabel;
    private JSpinner nbProducts;
    private JSpinner time;
    private JButton ok;
    private JPanel content;
    private JPanel options;
    private JPanel valid;
    private ViewPLEDGE viewPLEDGE;

    public ViewConfigurationGeneration(ModelPLEDGE model, ViewPLEDGE viewPLEDGE) {
        super((Frame)viewPLEDGE, CONFIG_GENERATION);
        this.viewPLEDGE = viewPLEDGE;
        this.model = model;
        this.content = new JPanel(new BorderLayout());
        this.valid = new JPanel();
        this.options = new JPanel(new GridBagLayout());
        this.nbProductsLabel = new JLabel(NB_PRODUCTS, 2);
        this.timeLabel = new JLabel(TIME, 2);
        this.nbProducts = new JSpinner(new SpinnerNumberModel(model.getNbProductsToGenerate(), 1, 1000000, 1));
        this.time = new JSpinner(new SpinnerNumberModel(model.getGenerationTimeMSAllowed() / 1000L, 1.0, 1000000.0, 1.0));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(20, 15, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 512;
        this.options.add((Component)this.nbProductsLabel, c);
        c.gridx = 1;
        c.anchor = 768;
        this.options.add((Component)this.nbProducts, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 512;
        this.options.add((Component)this.timeLabel, c);
        c.gridx = 1;
        c.anchor = 768;
        this.options.add((Component)this.time, c);
        this.ok = new JButton(OK);
        this.valid.add(this.ok);
        this.content.add((Component)this.options, "Center");
        this.content.add((Component)this.valid, "South");
        this.add(this.content);
        this.setSize(new Dimension(500, 150));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void update(Observable o, Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewConfigurationGeneration.this.nbProducts.setValue(ViewConfigurationGeneration.this.model.getNbProductsToGenerate());
                ViewConfigurationGeneration.this.time.setValue(ViewConfigurationGeneration.this.model.getGenerationTimeMSAllowed() / 1000L);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public JButton getOk() {
        return this.ok;
    }

    public JSpinner getNbProducts() {
        return this.nbProducts;
    }

    public JSpinner getTime() {
        return this.time;
    }
}

