/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pledge.core.ModelPLEDGE;
import pledge.gui.AdapterConstraints;

public class ViewConstraints
extends JPanel
implements Observer {
    private static final String TITLE = "CNF Constraints";
    private static final int D_WIDTH = 300;
    private static final Color GRAY = new Color(220, 220, 220);
    private ModelPLEDGE model;
    private AdapterConstraints modelAdapter;
    private JList constraintsList;
    private JScrollPane scrollPane;

    public ViewConstraints(final ModelPLEDGE model) {
        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        this.modelAdapter = new AdapterConstraints(model);
        this.constraintsList = new JList(this.modelAdapter);
        this.scrollPane = new JScrollPane(this.constraintsList);
        this.scrollPane.setPreferredSize(new Dimension(300, this.getHeight()));
        this.constraintsList.setSelectionMode(0);
        this.constraintsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg) {
                if (!arg.getValueIsAdjusting()) {
                    model.setCurrentConstraint(ViewConstraints.this.constraintsList.getSelectedIndex());
                }
            }
        });
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void update(Observable o, final Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (arg != null) {
                    ViewConstraints.this.modelAdapter.update();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

