/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pledge.core.ModelPLEDGE;

public class ViewFeatureModelInformation
extends JPanel
implements Observer {
    private ModelPLEDGE model;
    private static final String TITLE = "Feature Model Information";
    public static final String NAME = "Name:";
    public static final String FORMAT = "Format:";
    public static final String CONSTRAINTS = "Number of CNF constraints:";
    public static final String FEATURES = "Number of features:";
    public static final String CORE = "Number of core features:";
    public static final String DEAD = "Number of dead features:";
    private JLabel nameLabel;
    private JLabel name;
    private JLabel formatLabel;
    private JLabel format;
    private JLabel constraintsLabel;
    private JLabel constraints;
    private JLabel featuresLabel;
    private JLabel features;
    private JLabel coreLabel;
    private JLabel core;
    private JLabel deadLabel;
    private JLabel dead;

    public ViewFeatureModelInformation(ModelPLEDGE model) {
        super(new GridBagLayout());
        this.model = model;
        model.addObserver(this);
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
        this.nameLabel = new JLabel(NAME);
        this.name = new JLabel("-", 2);
        this.formatLabel = new JLabel(FORMAT);
        this.format = new JLabel("-", 2);
        this.constraintsLabel = new JLabel(CONSTRAINTS);
        this.constraints = new JLabel("-", 2);
        this.featuresLabel = new JLabel(FEATURES);
        this.features = new JLabel("-", 2);
        this.coreLabel = new JLabel(CORE);
        this.core = new JLabel("-", 2);
        this.deadLabel = new JLabel(DEAD);
        this.dead = new JLabel("-", 2);
        GridBagConstraints c = new GridBagConstraints();
        Insets i = new Insets(20, 15, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = i;
        c.anchor = 768;
        this.add((Component)this.nameLabel, c);
        i = new Insets(20, 15, 0, 0);
        c.gridx = 1;
        c.insets = i;
        c.anchor = 512;
        this.add((Component)this.name, c);
        c.gridx = 2;
        c.anchor = 768;
        this.add((Component)this.constraintsLabel, c);
        c.gridx = 3;
        c.anchor = 512;
        this.add((Component)this.constraints, c);
        c.gridx = 4;
        c.anchor = 768;
        this.add((Component)this.coreLabel, c);
        c.gridx = 5;
        c.anchor = 512;
        this.add((Component)this.core, c);
        i = new Insets(10, 15, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = i;
        c.anchor = 768;
        this.add((Component)this.formatLabel, c);
        i = new Insets(10, 15, 10, 0);
        c.gridx = 1;
        c.insets = i;
        c.anchor = 512;
        this.add((Component)this.format, c);
        c.gridx = 2;
        c.anchor = 768;
        this.add((Component)this.featuresLabel, c);
        c.gridx = 3;
        c.anchor = 512;
        this.add((Component)this.features, c);
        c.gridx = 4;
        c.anchor = 768;
        this.add((Component)this.deadLabel, c);
        c.gridx = 5;
        c.anchor = 512;
        this.add((Component)this.dead, c);
    }

    @Override
    public void update(Observable o, final Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (arg != null && ViewFeatureModelInformation.this.model.getSolver() != null) {
                    ViewFeatureModelInformation.this.name.setText(ViewFeatureModelInformation.this.model.getFeatureModelName());
                    ViewFeatureModelInformation.this.format.setText(ViewFeatureModelInformation.this.model.getFeatureModelFormat().name());
                    ViewFeatureModelInformation.this.constraints.setText("" + ViewFeatureModelInformation.this.model.getFeatureModelConstraintsString().size());
                    ViewFeatureModelInformation.this.features.setText("" + ViewFeatureModelInformation.this.model.getFeaturesList().size());
                    ViewFeatureModelInformation.this.core.setText("" + ViewFeatureModelInformation.this.model.getCoreFeatures().size());
                    ViewFeatureModelInformation.this.dead.setText("" + ViewFeatureModelInformation.this.model.getDeadFeatures().size());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

