/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import pledge.core.ModelPLEDGE;
import pledge.gui.AdapterFeatures;
import pledge.gui.views.ViewPLEDGE;

public class ViewFeatures
extends JPanel
implements Observer {
    private static final String TITLE = "Features";
    public static final String[] COLUMN_TITLES = new String[]{"Number", "Name", "Type"};
    private ModelPLEDGE model;
    private AdapterFeatures modelAdapter;
    private JTable featuresTable;
    private JScrollPane scrollPane;

    public ViewFeatures(ModelPLEDGE model) {
        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        this.modelAdapter = new AdapterFeatures(model);
        this.featuresTable = new JTable(this.modelAdapter);
        this.featuresTable.setAutoCreateRowSorter(true);
        TableCellRenderer headerRenderer = this.featuresTable.getTableHeader().getDefaultRenderer();
        ((DefaultTableCellRenderer)headerRenderer).setHorizontalAlignment(0);
        this.featuresTable.setOpaque(true);
        Cell cell = new Cell();
        for (int i = 0; i < this.featuresTable.getColumnModel().getColumnCount(); ++i) {
            this.featuresTable.getColumnModel().getColumn(i).setCellRenderer(cell);
        }
        this.scrollPane = new JScrollPane(this.featuresTable);
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void update(Observable o, final Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (arg != null) {
                    ViewFeatures.this.modelAdapter.update();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    private class Cell
    extends DefaultTableCellRenderer {
        public Cell() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.white);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (row % 2 == 0) {
                    this.setBackground(ViewPLEDGE.BLUE_COLOR);
                } else {
                    this.setBackground(Color.white);
                }
            }
            return this;
        }
    }
}

