/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import pledge.core.ModelPLEDGE;
import pledge.gui.controllers.ControllerCloseAbout;
import pledge.gui.controllers.ControllerCloseEditConstraints;
import pledge.gui.controllers.ControllerCoverage;
import pledge.gui.controllers.ControllerDisplayAbout;
import pledge.gui.controllers.ControllerDisplayDocumentation;
import pledge.gui.controllers.ControllerDisplayEditConstraints;
import pledge.gui.controllers.ControllerGenerateProducts;
import pledge.gui.controllers.ControllerGenerationTechnique;
import pledge.gui.controllers.ControllerLoadFeatureModel;
import pledge.gui.controllers.ControllerLoadProducts;
import pledge.gui.controllers.ControllerLoadProductsFM;
import pledge.gui.controllers.ControllerPrioritizationTechnique;
import pledge.gui.controllers.ControllerPrioritizeProducts;
import pledge.gui.controllers.ControllerQuit;
import pledge.gui.controllers.ControllerRemoveConstraint;
import pledge.gui.controllers.ControllerSaveProducts;
import pledge.gui.controllers.ControllerViewConfigurationGeneration;
import pledge.gui.views.ViewAboutWindow;
import pledge.gui.views.ViewConfigurationGeneration;
import pledge.gui.views.ViewConstraints;
import pledge.gui.views.ViewDocumentation;
import pledge.gui.views.ViewEditConstraints;
import pledge.gui.views.ViewFeatureModelInformation;
import pledge.gui.views.ViewFeatures;
import pledge.gui.views.ViewMenuBar;
import pledge.gui.views.ViewProducts;
import pledge.gui.views.ViewStatusBar;
import pledge.gui.views.ViewToolBar;

public class ViewPLEDGE
extends JFrame
implements Observer {
    public static final Color BLUE_COLOR = new Color(232, 239, 247);
    public static final int D_WIDTH = 900;
    public static final int D_HEIGHT = 600;
    public static final String TITLE = "PLEDGE - A Product Line EDitor and tests GEneration tool";
    private static final String QUIT_MESSAGE = "Quit PLEDGE will interrupt any running task. Do you want to continue ?";
    private static final String QUIT_TITLE = "Quit PLEDGE";
    private static final String FILE_CHOOSER_FEATURE_MODEL_TITLE = "Load a Feature Model";
    private static final String FILE_CHOOSER_PRODUCTS_TITLE = "Load Products";
    private static final String FILE_SAVER_PRODUCTS_TITLE = "Save Products";
    private static final String COVERAGE_TITLE = "Pairwise coverage";
    private final FileNameExtensionFilter featureModelFileFilter = new FileNameExtensionFilter("SPLOT or DIMACS Feature Models (.xml, .dimacs)", "xml", "dimacs");
    private static final String TAB_FEATURE_MODEL = "Feature Model";
    private final URL BACKGROUND_URL = this.getClass().getResource("icons/logo.png");
    private JFileChooser featureModelChooser;
    private JFileChooser productsChooser;
    private JFileChooser productsSaver;
    private ModelPLEDGE model = new ModelPLEDGE();
    private ControllerQuit controllerQuit;
    private ControllerLoadFeatureModel controllerLoadFeatureModel;
    private ControllerLoadProducts controllerLoadProducts;
    private ControllerSaveProducts controllerSaveProducts;
    private ControllerGenerationTechnique controllerGenerationTechnique;
    private ControllerPrioritizationTechnique controllerPrioritizationTechnique;
    private ControllerDisplayAbout controllerDisplayAbout;
    private ControllerCloseAbout controllerCloseAbout;
    private ControllerViewConfigurationGeneration controllerViewConfigurationGeneration;
    private ControllerGenerateProducts controllerGenerateProducts;
    private ControllerPrioritizeProducts controllerPrioritizeProducts;
    private ControllerCoverage controllerCoverage;
    private ControllerDisplayDocumentation controllerDisplayDocumentation;
    private ControllerDisplayEditConstraints controllerDisplayEditConstraints;
    private ControllerCloseEditConstraints controllerCloseEditConstraints;
    private ControllerRemoveConstraint controllerRemoveConstraint;
    private ControllerLoadProductsFM controllerLoadProductsFM;
    private ViewMenuBar viewMenuBar;
    private ViewConstraints viewConstraints;
    private ViewFeatures viewFeatures;
    private ViewToolBar viewToolBar;
    private ViewStatusBar viewStatusBar;
    private ViewAboutWindow viewAboutWindow;
    private ViewFeatureModelInformation viewFeatureModelInformation;
    private ViewConfigurationGeneration viewConfigurationGeneration;
    private ViewProducts viewProducts;
    private JPanel content;
    private JPanel background;
    private ViewDocumentation viewDocumentation;
    private ViewEditConstraints viewEditConstraints;

    public ViewPLEDGE() {
        super(TITLE);
        this.model.addObserver(this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ViewPLEDGE.this.viewDocumentation = ViewDocumentation.getInstance();
                ViewPLEDGE.this.viewDocumentation.setLocationRelativeTo(ViewPLEDGE.this);
            }
        }).start();
        this.viewAboutWindow = new ViewAboutWindow(this);
        this.viewMenuBar = new ViewMenuBar(this.model);
        this.viewConstraints = new ViewConstraints(this.model);
        this.viewFeatures = new ViewFeatures(this.model);
        this.viewStatusBar = new ViewStatusBar(this.model);
        this.viewFeatureModelInformation = new ViewFeatureModelInformation(this.model);
        this.viewConfigurationGeneration = new ViewConfigurationGeneration(this.model, this);
        this.viewProducts = new ViewProducts(this.model);
        this.viewToolBar = new ViewToolBar(this.model);
        this.viewEditConstraints = new ViewEditConstraints(this.model, this);
        this.controllerQuit = new ControllerQuit(this.model, this);
        this.controllerLoadFeatureModel = new ControllerLoadFeatureModel(this.model, this);
        this.controllerLoadProducts = new ControllerLoadProducts(this.model, this);
        this.controllerLoadProductsFM = new ControllerLoadProductsFM(this.model, this);
        this.controllerDisplayAbout = new ControllerDisplayAbout(this);
        this.controllerCloseAbout = new ControllerCloseAbout(this);
        this.controllerViewConfigurationGeneration = new ControllerViewConfigurationGeneration(this);
        this.controllerGenerateProducts = new ControllerGenerateProducts(this.model, this, this.viewConfigurationGeneration);
        this.controllerCoverage = new ControllerCoverage(this.model, this);
        this.controllerSaveProducts = new ControllerSaveProducts(this.model, this);
        this.controllerPrioritizeProducts = new ControllerPrioritizeProducts(this.model, this);
        this.controllerDisplayDocumentation = new ControllerDisplayDocumentation(this);
        this.controllerDisplayEditConstraints = new ControllerDisplayEditConstraints(this);
        this.controllerCloseEditConstraints = new ControllerCloseEditConstraints(this);
        this.controllerRemoveConstraint = new ControllerRemoveConstraint(this.model);
        this.viewEditConstraints.getCloseButton().addActionListener(this.controllerCloseEditConstraints);
        this.viewAboutWindow.getCloseButton().addActionListener(this.controllerCloseAbout);
        this.viewMenuBar.getQuit().addActionListener(this.controllerQuit);
        this.viewMenuBar.getLoadFeatureModel().addActionListener(this.controllerLoadFeatureModel);
        this.viewMenuBar.getLoadProducts().addActionListener(this.controllerLoadProducts);
        this.viewMenuBar.getLoadProductsFM().addActionListener(this.controllerLoadProductsFM);
        this.viewMenuBar.getAbout().addActionListener(this.controllerDisplayAbout);
        this.viewMenuBar.getGenerate().addActionListener(this.controllerViewConfigurationGeneration);
        this.viewMenuBar.getSaveProducts().addActionListener(this.controllerSaveProducts);
        this.viewMenuBar.getPrioritize().addActionListener(this.controllerPrioritizeProducts);
        this.viewMenuBar.getDoc().addActionListener(this.controllerDisplayDocumentation);
        this.viewMenuBar.getCoverage().addActionListener(this.controllerCoverage);
        this.viewConfigurationGeneration.getOk().addActionListener(this.controllerGenerateProducts);
        this.controllerGenerationTechnique = new ControllerGenerationTechnique(this.model, this.viewMenuBar);
        for (JRadioButtonMenuItem button : this.viewMenuBar.getGenerationTechniqueButtons()) {
            button.addActionListener(this.controllerGenerationTechnique);
        }
        this.controllerPrioritizationTechnique = new ControllerPrioritizationTechnique(this.model, this.viewMenuBar);
        for (JRadioButtonMenuItem button : this.viewMenuBar.getPrioritizationTechniqueButtons()) {
            button.addActionListener(this.controllerPrioritizationTechnique);
        }
        this.viewToolBar.getQuit().addActionListener(this.controllerQuit);
        this.viewToolBar.getLoadFM().addActionListener(this.controllerLoadFeatureModel);
        this.viewToolBar.getLoadProducts().addActionListener(this.controllerLoadProducts);
        this.viewToolBar.getGenerate().addActionListener(this.controllerViewConfigurationGeneration);
        this.viewToolBar.getSaveProducts().addActionListener(this.controllerSaveProducts);
        this.viewToolBar.getPrioritize().addActionListener(this.controllerPrioritizeProducts);
        this.viewToolBar.getAddConstraint().addActionListener(this.controllerDisplayEditConstraints);
        this.viewToolBar.getRemoveConstraint().addActionListener(this.controllerRemoveConstraint);
        this.setJMenuBar(this.viewMenuBar);
        this.featureModelChooser = new JFileChooser();
        this.featureModelChooser.setMultiSelectionEnabled(false);
        this.featureModelChooser.setAcceptAllFileFilterUsed(false);
        this.featureModelChooser.addChoosableFileFilter(this.featureModelFileFilter);
        this.featureModelChooser.setDialogTitle(FILE_CHOOSER_FEATURE_MODEL_TITLE);
        this.productsChooser = new JFileChooser();
        this.productsChooser.setMultiSelectionEnabled(false);
        this.productsChooser.setAcceptAllFileFilterUsed(false);
        this.productsChooser.setDialogTitle(FILE_CHOOSER_PRODUCTS_TITLE);
        this.productsSaver = new JFileChooser();
        this.productsChooser.setMultiSelectionEnabled(false);
        this.productsChooser.setAcceptAllFileFilterUsed(false);
        this.productsSaver.setDialogTitle(FILE_SAVER_PRODUCTS_TITLE);
        this.add((Component)this.viewStatusBar, "South");
        this.content = new JPanel(new BorderLayout());
        this.viewProducts.setVisible(false);
        this.add((Component)this.viewToolBar, "First");
        this.background = new JPanel(new GridLayout(1, 1));
        this.background.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(172, 168, 153)));
        this.background.setBackground(Color.white);
        this.background.add((Component)new JLabel(new ImageIcon(this.BACKGROUND_URL)), "Center");
        this.add((Component)this.background, "Center");
        this.setSize(900, 600);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void displayCoverage(String cov) {
        JOptionPane.showMessageDialog(this, cov, COVERAGE_TITLE, 1);
    }

    public void displayDocumentation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewPLEDGE.this.viewDocumentation.setVisible(true);
            }
        });
    }

    public boolean getQuitConfirmation() {
        return JOptionPane.showConfirmDialog(this, QUIT_MESSAGE, QUIT_TITLE, 0) == 0;
    }

    public File displayFileChooser(FileType fileType) {
        switch (fileType) {
            case FEATURE_MODEL: {
                if (this.featureModelChooser.showOpenDialog(this) != 0) break;
                return this.featureModelChooser.getSelectedFile();
            }
            case PRODUCTS: {
                if (this.productsChooser.showOpenDialog(this) != 0) break;
                return this.productsChooser.getSelectedFile();
            }
        }
        return null;
    }

    public File displayFileSaver() {
        if (this.productsSaver.showSaveDialog(this) == 0) {
            return this.productsSaver.getSelectedFile();
        }
        return null;
    }

    @Override
    public void update(Observable o, final Object arg) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (arg != null) {
                    ViewPLEDGE.this.remove(ViewPLEDGE.this.background);
                    ViewPLEDGE.this.add((Component)ViewPLEDGE.this.content, "Center");
                    ViewPLEDGE.this.viewStatusBar.addSeparator();
                    if (ViewPLEDGE.this.model.getSolver() == null) {
                        ViewPLEDGE.this.viewFeatureModelInformation.setVisible(false);
                        ViewPLEDGE.this.viewConstraints.setVisible(false);
                        ViewPLEDGE.this.viewFeatures.setVisible(false);
                        ViewPLEDGE.this.content.add((Component)ViewPLEDGE.this.viewProducts, "Center");
                    } else {
                        ViewPLEDGE.this.content.add((Component)ViewPLEDGE.this.viewConstraints, "East");
                        ViewPLEDGE.this.content.add((Component)ViewPLEDGE.this.viewFeatures, "Center");
                        ViewPLEDGE.this.content.add((Component)ViewPLEDGE.this.viewFeatureModelInformation, "North");
                        ViewPLEDGE.this.content.add((Component)ViewPLEDGE.this.viewProducts, "South");
                        ViewPLEDGE.this.viewFeatureModelInformation.setVisible(true);
                        ViewPLEDGE.this.viewConstraints.setVisible(true);
                        ViewPLEDGE.this.viewFeatures.setVisible(true);
                    }
                    ViewPLEDGE.this.validate();
                    SwingUtilities.updateComponentTreeUI(ViewPLEDGE.this);
                }
                ViewPLEDGE.this.viewProducts.setVisible(ViewPLEDGE.this.model.getProducts() != null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayViewAboutWindow(final boolean display) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewPLEDGE.this.viewAboutWindow.setVisible(display);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayViewEditConstraints(final boolean display) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewPLEDGE.this.viewEditConstraints.setVisible(display);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayViewConfigurationGeneration(final boolean display) {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewPLEDGE.this.viewConfigurationGeneration.setVisible(display);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public void displayError(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public static enum FileType {
        FEATURE_MODEL,
        PRODUCTS;

    }
}

