/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import pledge.core.ModelPLEDGE;

public class ViewToolBar
extends JToolBar
implements Observer {
    public static final String LOAD_FM = "Load a Feature Model";
    public static final String LOAD_PRODUCTS = "Load Products";
    public static final String QUIT = "Quit PLEDGE";
    public static final String SAVE_PRODUCTS = "Save the products";
    public static final String GENERATE = "Generate products";
    public static final String PRIORITIZE = "Prioritize products";
    public static final String STOP = "Stop the execution";
    public static final String ADD_CONSTRAINT = "Add a constraint to the Feature Model";
    public static final String REMOVE_CONSTRAINT = "Remove a constraint from the Feature Model";
    private ModelPLEDGE model;
    private ImageIcon loadFMIcon;
    private ImageIcon loadProductsIcon;
    private ImageIcon quitIcon;
    private ImageIcon saveProductsIcon;
    private ImageIcon stopIcon;
    private ImageIcon generateIcon;
    private ImageIcon prioritizeIcon;
    private ImageIcon addConstraintIcon;
    private ImageIcon removeConstraintIcon;
    private JButton loadFM;
    private JButton loadProducts;
    private JButton quit;
    private JButton saveProducts;
    private JButton generate;
    private JButton prioritize;
    private JButton stop;
    private JButton addConstraint;
    private JButton removeConstraint;
    private final URL urlLoadFM = this.getClass().getResource("icons/load_fm.png");
    private final URL urlLoadProducts = this.getClass().getResource("icons/load_products.png");
    private final URL urlQUIT = this.getClass().getResource("icons/exit.png");
    private final URL urlSaveProducts = this.getClass().getResource("icons/save_products.png");
    private final URL urlGenerate = this.getClass().getResource("icons/generate.png");
    private final URL urlPrioritize = this.getClass().getResource("icons/prioritize.png");
    private final URL urlStop = this.getClass().getResource("icons/stop.png");
    private final URL urlAddConstraint = this.getClass().getResource("icons/add.png");
    private final URL urlRemoveConstraint = this.getClass().getResource("icons/remove.png");

    public ViewToolBar(ModelPLEDGE model) {
        this.model = model;
        model.addObserver(this);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.loadFMIcon = new ImageIcon(this.urlLoadFM);
        this.loadProductsIcon = new ImageIcon(this.urlLoadProducts);
        this.quitIcon = new ImageIcon(this.urlQUIT);
        this.saveProductsIcon = new ImageIcon(this.urlSaveProducts);
        this.generateIcon = new ImageIcon(this.urlGenerate);
        this.prioritizeIcon = new ImageIcon(this.urlPrioritize);
        this.addConstraintIcon = new ImageIcon(this.urlAddConstraint);
        this.removeConstraintIcon = new ImageIcon(this.urlRemoveConstraint);
        this.stopIcon = new ImageIcon(this.urlStop);
        this.loadFM = new JButton(this.loadFMIcon);
        this.loadFM.setToolTipText(LOAD_FM);
        this.loadFM.setFocusPainted(false);
        this.loadProducts = new JButton(this.loadProductsIcon);
        this.loadProducts.setToolTipText(LOAD_PRODUCTS);
        this.loadProducts.setFocusPainted(false);
        this.quit = new JButton(this.quitIcon);
        this.quit.setToolTipText(QUIT);
        this.quit.setFocusPainted(false);
        this.saveProducts = new JButton(this.saveProductsIcon);
        this.saveProducts.setToolTipText(SAVE_PRODUCTS);
        this.saveProducts.setFocusPainted(false);
        this.generate = new JButton(this.generateIcon);
        this.generate.setToolTipText(GENERATE);
        this.generate.setFocusPainted(false);
        this.prioritize = new JButton(this.prioritizeIcon);
        this.prioritize.setToolTipText(PRIORITIZE);
        this.prioritize.setFocusPainted(false);
        this.stop = new JButton(this.stopIcon);
        this.stop.setToolTipText(STOP);
        this.stop.setFocusPainted(false);
        this.addConstraint = new JButton(this.addConstraintIcon);
        this.addConstraint.setToolTipText(ADD_CONSTRAINT);
        this.addConstraint.setFocusPainted(false);
        this.removeConstraint = new JButton(this.removeConstraintIcon);
        this.removeConstraint.setToolTipText(REMOVE_CONSTRAINT);
        this.removeConstraint.setFocusPainted(false);
        this.add(this.loadFM);
        this.add(this.loadProducts);
        this.add(this.quit);
        this.addSeparator();
        this.add(this.generate);
        this.add(this.prioritize);
        this.add(this.stop);
        this.add(this.saveProducts);
        this.addSeparator();
        this.add(this.addConstraint);
        this.add(this.removeConstraint);
        this.setEnabled();
    }

    public JButton getLoadFM() {
        return this.loadFM;
    }

    public JButton getLoadProducts() {
        return this.loadProducts;
    }

    public JButton getQuit() {
        return this.quit;
    }

    public JButton getGenerate() {
        return this.generate;
    }

    public JButton getPrioritize() {
        return this.prioritize;
    }

    public JButton getSaveProducts() {
        return this.saveProducts;
    }

    public JButton getStop() {
        return this.stop;
    }

    public JButton getAddConstraint() {
        return this.addConstraint;
    }

    public JButton getRemoveConstraint() {
        return this.removeConstraint;
    }

    private void setEnabled() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewToolBar.this.generate.setEnabled(ViewToolBar.this.model.getSolver() != null && !ViewToolBar.this.model.isRunning());
                ViewToolBar.this.prioritize.setEnabled(ViewToolBar.this.model.getProducts() != null && !ViewToolBar.this.model.isRunning());
                ViewToolBar.this.saveProducts.setEnabled(ViewToolBar.this.model.getProducts() != null);
                ViewToolBar.this.loadFM.setEnabled(!ViewToolBar.this.model.isRunning());
                ViewToolBar.this.loadProducts.setEnabled(!ViewToolBar.this.model.isRunning());
                ViewToolBar.this.stop.setEnabled(ViewToolBar.this.model.isRunning());
                ViewToolBar.this.addConstraint.setEnabled(ViewToolBar.this.model.getSolver() != null && !ViewToolBar.this.model.isRunning());
                ViewToolBar.this.removeConstraint.setEnabled(ViewToolBar.this.model.getSolver() != null && !ViewToolBar.this.model.isRunning() && ViewToolBar.this.model.getCurrentConstraint() >= 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setEnabled();
    }
}

