/*
 * Decompiled with CFR 0.152.
 */
package splar.apps;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.JFactory;
import splar.plugins.configuration.bdd.javabdd.BDDConfigurationEngine;

public class SPLOTCatalogConfigurationBackEnd {
    String productCatalogFilePath = "c:\\users\\marcilio\\eclipse\\splot-project\\webcontent\\models\\catalog\\dell_laptops_usa_fm_catalog.csv";
    int nodeNum = 100000;
    int cacheSize = 100000;

    public static void main(String[] args) {
        new SPLOTCatalogConfigurationBackEnd().generateAndSaveInteractiveConfigurationBDD();
    }

    public void generateAndSaveInteractiveConfigurationBDD() {
        try {
            String path = "c:\\users\\marcilio\\eclipse\\splot-project\\webcontent\\models\\catalog\\";
            String fileName = "dell_laptops_usa_fm";
            String featureModelPath = "file:///" + path + fileName + ".xml";
            String catalogPath = path + fileName + "_catalog.csv";
            BDDConfigurationEngine confEngine = new BDDConfigurationEngine(featureModelPath, 1000000, 1000000);
            confEngine.addProductCatalog(catalogPath);
            confEngine.reset();
            confEngine.getReasoner().saveToFile(path, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extractUniqueProductAttributes() {
        try {
            int i;
            CSVReader reader = new CSVReader((Reader)new FileReader(this.productCatalogFilePath));
            String[] header = reader.readNext();
            boolean[] optional = new boolean[header.length];
            Arrays.fill(optional, false);
            ArrayList uniqueColumnValues = new ArrayList(header.length);
            for (int i2 = 0; i2 < header.length; ++i2) {
                uniqueColumnValues.add(i2, new LinkedHashSet());
            }
            String[] nextLine = reader.readNext();
            int line = 0;
            while (nextLine != null) {
                for (i = 0; i < header.length; ++i) {
                    String value = nextLine[i].trim();
                    if (value.length() > 0) {
                        ((Set)uniqueColumnValues.get(i)).add(value);
                        if (value.indexOf(40) == -1 && value.indexOf(41) == -1) continue;
                        throw new Exception("Value contains parantheses (column: " + header[i] + " /line: " + line + " ): " + value);
                    }
                    if (optional[i]) continue;
                    optional[i] = true;
                    System.out.println("Optional Feature: " + header[i]);
                }
                nextLine = reader.readNext();
                ++line;
            }
            reader.close();
            for (i = 0; i < header.length; ++i) {
                if (i < 2 || header[i].startsWith("$")) continue;
                System.out.println(header[i] + "----------------------------------------");
                String[] uniqueValues = ((Set)uniqueColumnValues.get(i)).toArray(new String[0]);
                Collections.sort(Arrays.asList(uniqueValues));
                System.out.println("\t\t\t" + (optional[i] ? ":o " : ":m ") + header[i]);
                for (String value : uniqueValues) {
                    System.out.println("\t\t\t\t: " + value + " (" + this.genID(header[i], value) + ")");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String genID(String header, String name) {
        String lex = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        for (int i = 0; i < name.length(); ++i) {
            if (lex.indexOf(name.charAt(i)) != -1) continue;
            name = name.replace(name.charAt(i), '_');
        }
        return ("_" + header + "_" + name).toLowerCase();
    }

    public List<String> toListOfIDs(String[] header, String[] values) {
        ArrayList<String> ids = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            ids.add(i, this.genID(header[i], values[i]));
        }
        return ids;
    }

    public void generateCrossTreeConstraintAsCNFClauses() {
        try {
            LinkedList<List<String>> catalog = new LinkedList<List<String>>();
            CSVReader reader = new CSVReader((Reader)new FileReader(this.productCatalogFilePath));
            String[] header = reader.readNext();
            String[] nextLine = reader.readNext();
            while (nextLine != null) {
                catalog.add(this.toListOfIDs(header, nextLine));
                nextLine = reader.readNext();
            }
            reader.close();
            LinkedList<String> varIndex2NameMap = new LinkedList<String>();
            HashMap<String, Integer> varName2IndexMap = new HashMap<String, Integer>();
            for (List list : catalog) {
                for (String item : list) {
                    if (varName2IndexMap.containsKey(item)) continue;
                    varIndex2NameMap.add(item);
                    varName2IndexMap.put(item, 0);
                }
            }
            Collections.shuffle(varIndex2NameMap);
            int countVars = 0;
            for (String var : varIndex2NameMap) {
                varName2IndexMap.put(var, countVars++);
            }
            System.out.println("\nVARIABLES ORDER/INDEXES -------------------");
            ArrayList arrayList = new ArrayList(varIndex2NameMap);
            Collections.sort(arrayList);
            for (String var : arrayList) {
                System.out.println(varName2IndexMap.get(var) + ": " + var);
            }
            BDDFactory bddFactory = JFactory.init((int)this.nodeNum, (int)this.cacheSize);
            bddFactory.setVarNum(countVars);
            BDD fbdd = bddFactory.zero();
            for (List list : catalog) {
                BDD tempBDD = bddFactory.one();
                HashSet productSet = new HashSet(list);
                for (String distinctItem : varIndex2NameMap) {
                    if (productSet.contains(distinctItem)) {
                        tempBDD.andWith(bddFactory.ithVar(((Integer)varName2IndexMap.get(distinctItem)).intValue()).id());
                        continue;
                    }
                    tempBDD.andWith(bddFactory.nithVar(((Integer)varName2IndexMap.get(distinctItem)).intValue()).id());
                }
                fbdd.orWith(tempBDD);
            }
            System.out.println("\nCNF FORMULA -------------------");
            boolean formulaIndex = true;
            System.out.println("\nPRODUCTS FROM BDD -------------------");
            System.out.println("BDD size: " + fbdd.nodeCount());
            System.out.println("Solutions: " + fbdd.satCount());
            System.out.println("Path count: " + fbdd.not().pathCount());
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean countProducts = false;
            BDD.AllSatIterator it = new BDD.AllSatIterator(fbdd);
            while (it.hasNext()) {
                linkedList.clear();
                byte[] path = it.nextSat();
                int index = 0;
                for (byte value : path) {
                    String var = (String)varIndex2NameMap.get(index);
                    if (value == 1) {
                        linkedList.add(var);
                    }
                    ++index;
                }
                Collections.sort(linkedList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

