/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.experiments;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelStatistics;
import splar.core.fm.XMLFeatureModel;
import splar.core.fm.randomization.RandomFeatureModel2;
import splar.core.heuristics.FORCEVariableOrderingHeuristic;
import splar.core.heuristics.FTPreOrderSortedECTraversalHeuristic;
import splar.core.heuristics.FTPreOrderTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.plugins.reasoners.bdd.javabdd.FMReasoningWithBDD;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDD;

public class GenBench {
    String mainPath = "c:\\users\\marcilio\\eclipse\\4watreason\\experiments\\thesis\\";
    int nodeNum = 5000000;
    int cacheSize = 1000000;
    double BDDTableIncreaseFactor = 0.2;
    double BDDGCFactor = 0.2;
    String heuristicName;
    int nf;
    double ECR;
    int numberOfFilesToGenerate;
    String modelNameSuffix = "";
    int nf_add;
    int vc;
    String collection;
    String collectionSet;
    String logFile;
    String tempFile;
    int startFromIndexInCollection = 1;
    int timeout = 3600000;
    String outputPath;
    boolean shrink = false;
    boolean checkSatistiability = true;
    boolean skipUnsatisfiableFeatureModels = true;
    boolean skipSatisfiableFeatureModels = !this.skipUnsatisfiableFeatureModels;
    int runIndex = 1;

    public static void main(String[] args) {
        new GenBench(args);
    }

    public GenBench(String[] args) {
        if (args.length < 4) {
            System.out.println("PARAMETERS");
            System.out.println("  args[0] = heuristic name (e.g Pre-CL-MinSpan or Pre-CL-Size or pre-order)");
            System.out.println("  args[1] = number of features");
            System.out.println("  args[2] = ECR [0-100]");
            System.out.println("  args[3] = number of files to process");
            System.out.println("  args[4] = Suffix to use on model names");
            System.out.println("---------------------------------------------------");
        } else {
            try {
                this.init(args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateCounterFile(int runIndex, int fileIndex) {
        File file = new File(this.mainPath + "\\" + this.tempFile);
        try {
            System.out.println(">> generating/updating file " + file.getName() + "...");
            System.out.println(">> runIndex=" + runIndex + ", fileIndex=" + fileIndex);
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));
            stream.writeInt(runIndex);
            stream.writeInt(fileIndex);
            stream.close();
        }
        catch (FileNotFoundException ex1) {
            ex1.printStackTrace();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    private void readCounterFile() {
        File file = new File(this.mainPath + "\\" + this.tempFile);
        try {
            System.out.println(">> reading file " + file.getName() + "...");
            DataInputStream stream = new DataInputStream(new FileInputStream(file));
            this.runIndex = stream.readInt() + 1;
            this.startFromIndexInCollection = stream.readInt() + 1;
            System.out.println(">> runIndex=" + this.runIndex + ", fileIndex=" + this.startFromIndexInCollection);
            stream.close();
        }
        catch (FileNotFoundException e1) {
            System.out.println("File does not exist!");
            this.updateCounterFile(1, 19);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void printInputParameters() {
        System.out.println("---------------------------------------------------");
        System.out.println(">> INPUT PARAMETERS");
        System.out.println("   - Heuristic............: " + this.heuristicName);
        System.out.println("   - Features.............: " + (this.nf + this.nf_add));
        System.out.println("   - ECR..................: " + (int)(this.ECR * 100.0) + "%");
        System.out.println("   - BDD table............: " + this.nodeNum + " nodes");
        System.out.println("   - Table increase factor: " + this.BDDTableIncreaseFactor * 100.0 + "%");
        System.out.println("   - Files in experiment..: " + this.numberOfFilesToGenerate);
        System.out.println("   - Log file.............: " + this.logFile);
        System.out.println("   - Temp file............: " + this.tempFile);
        System.out.println("---------------------------------------------------");
    }

    private void captureCommandLineParameters(String[] args) {
        this.heuristicName = args[0];
        this.nf = Integer.valueOf(args[1]);
        this.ECR = (double)Integer.valueOf(args[2]).intValue() / 100.0;
        this.numberOfFilesToGenerate = Integer.valueOf(args[3]);
        this.modelNameSuffix = args[4];
        this.nf_add = (int)((double)this.nf * 0.33);
        if (!this.shrink) {
            this.nf_add = 0;
        }
        this.vc = 0;
        if (this.ECR != 0.0) {
            this.vc = (int)((this.ECR + 0.05) * (double)(this.nf + this.nf_add));
        }
        this.collection = "FM" + this.nf;
        String sat = "SAT";
        if (this.skipSatisfiableFeatureModels) {
            sat = "UNSAT";
        }
        if (this.skipUnsatisfiableFeatureModels) {
            sat = "SAT";
        }
        this.collectionSet = sat + "_" + this.modelNameSuffix + "C";
        this.logFile = "GenBench-Stats-" + this.heuristicName + "-" + this.nf;
        this.tempFile = "GenBench-Temp-" + this.heuristicName + "-" + this.nf + "-" + this.collectionSet + ".txt";
        this.outputPath = "\\scalability";
    }

    private VariableOrderingHeuristic getHeuristic(String name, FeatureModel fm) {
        VariableOrderingHeuristic heuristic = null;
        if (this.heuristicName.compareToIgnoreCase("Pre-CL-MinSpan") == 0) {
            heuristic = new FTPreOrderSortedECTraversalHeuristic("Pre-CL-MinSpan", fm, 20);
        } else if (this.heuristicName.compareToIgnoreCase("Pre-CL-Size") == 0) {
            heuristic = new FTPreOrderSortedECTraversalHeuristic("Pre-CL-Size", fm, 10);
        } else if (this.heuristicName.compareToIgnoreCase("FORCE-Pre-CL-MinSpan") == 0) {
            FTPreOrderSortedECTraversalHeuristic tempHeuristic = new FTPreOrderSortedECTraversalHeuristic("Pre-CL-MinSpan", fm, 20);
            String[] order = tempHeuristic.run(fm.FM2CNF());
            heuristic = new FORCEVariableOrderingHeuristic("FORCE-Pre-CL-MinSpan", VariableOrderingHeuristic.variableOrderingAsBooleanVariableArray(order), 1);
        } else if (this.heuristicName.compareToIgnoreCase("FORCE-Pre-CL-Size") == 0) {
            FTPreOrderSortedECTraversalHeuristic tempHeuristic = new FTPreOrderSortedECTraversalHeuristic("Pre-CL-Size", fm, 10);
            String[] order = tempHeuristic.run(fm.FM2CNF());
            System.out.println(order);
            heuristic = new FORCEVariableOrderingHeuristic("FORCE-Pre-CL-Size", VariableOrderingHeuristic.variableOrderingAsBooleanVariableArray(order), 1);
        } else if (this.heuristicName.compareToIgnoreCase("FORCE") == 0) {
            heuristic = new FORCEVariableOrderingHeuristic("FORCE", 1);
        } else if (this.heuristicName.compareToIgnoreCase("Pre-Order") == 0) {
            heuristic = new FTPreOrderTraversalHeuristic("Pre-Order", fm);
        }
        return heuristic;
    }

    public void init(String[] args) throws Exception {
        this.captureCommandLineParameters(args);
        this.readCounterFile();
        System.out.println(">> generating feature models...");
        boolean genFile = false;
        String logFilePath = this.mainPath + this.outputPath + "\\logs\\" + this.logFile + "-" + this.collectionSet + "-" + this.runIndex + ".txt";
        PrintStream logStream = new PrintStream(logFilePath);
        System.out.println(">> Output file: " + this.logFile + "-" + this.collectionSet + "-" + this.runIndex + ".txt");
        int i = this.startFromIndexInCollection;
        while (i <= this.numberOfFilesToGenerate) {
            try {
                double realECR;
                this.printInputParameters();
                this.updateCounterFile(this.runIndex, i);
                FeatureModel fm = null;
                FeatureModelStatistics stats = null;
                boolean newFileCreated = true;
                String inputFileLocation = this.mainPath + this.outputPath + "\\files\\" + this.collection + this.collectionSet + "-" + i + ".xml";
                File file = new File(inputFileLocation);
                if (!file.exists()) {
                    System.out.println("Creating test file: " + file.getName());
                    fm = new RandomFeatureModel2(this.collection + this.collectionSet + "-" + i, this.nf + this.nf_add, 25, 35, 20, 20, 1, 6, 6, 0);
                    fm.loadModel();
                    if (this.vc > 0) {
                        try {
                            RandomFeatureModel2.createExtraConstraints(fm, this.vc, this.vc / 2, 2, new int[][]{{1, 20, 100, 70}, {20, 20, 80, 80}, {40, 30, 80, 80}, {60, 30, 80, 80}});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (this.shrink) {
                        fm.shrink();
                    }
                } else {
                    System.out.println("Reusing existing test file: " + file.getName());
                    newFileCreated = false;
                    fm = new XMLFeatureModel(inputFileLocation);
                    fm.loadModel();
                }
                if (Math.abs((realECR = (double)(100.0f * ((float)fm.countConstraintsVariables() / (1.0f * (float)fm.countNodes())))) - 100.0 * this.ECR) > 3.0) {
                    System.out.println("Real ECR: " + realECR + "   Desired ECR: " + 100.0 * this.ECR);
                    System.out.println("ECR too different from the one specified, trying again...");
                    continue;
                }
                System.out.println("---------------------------------------------------");
                System.out.println(">> RESULTS (run=" + this.runIndex + "/file=" + i + ")");
                System.out.println("ECR......:  " + realECR);
                if (!file.exists()) {
                    if (this.checkSatistiability) {
                        System.out.println(">>>> Checking feature model satisfiability...");
                        if (!this.isFMSatisfiable(fm)) {
                            if (this.skipUnsatisfiableFeatureModels) {
                                System.out.println(">>>> UNSatisfiable!! (SKIPPED)");
                                continue;
                            }
                            System.out.println(">>>> UNSatisfiable!! (PROCESSING)");
                            genFile = true;
                        } else {
                            if (this.skipSatisfiableFeatureModels) {
                                System.out.println(">>>> Satisfiable!! (SKIPPED)");
                                continue;
                            }
                            System.out.println(">>>> Satisfiable!! (PROCESSING)");
                            genFile = true;
                        }
                    } else {
                        genFile = true;
                    }
                }
                stats = new FeatureModelStatistics(fm);
                stats.update();
                ReasoningWithBDD r = null;
                VariableOrderingHeuristic heuristic = this.getHeuristic(this.heuristicName, fm);
                try {
                    if (this.checkSatistiability) {
                        System.out.println(">> Building BDD with heuristic " + this.heuristicName + "...");
                        genFile = false;
                        r = new FMReasoningWithBDD(fm, heuristic, this.nodeNum, this.cacheSize, (long)this.timeout, "pre-order");
                        r.getBDDFactory().setIncreaseFactor(this.BDDTableIncreaseFactor);
                        r.getBDDFactory().setMinFreeNodes(this.BDDGCFactor);
                        r.init();
                        if (r.getBDD().nodeCount() > 0) {
                            genFile = true;
                        } else if (!this.skipUnsatisfiableFeatureModels) {
                            genFile = true;
                        }
                    } else {
                        genFile = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                if (genFile) {
                    if (newFileCreated) {
                        this.saveFeatureModel(fm, stats, inputFileLocation);
                    }
                    if (r != null) {
                        System.out.println("Heur Time: " + r.getHeuristicRunningTime() + " ms");
                        System.out.println("BDD Time.: " + r.getBDDBuildingTime() + " ms");
                        System.out.println("BDD......: " + r.getBDD().nodeCount());
                    }
                    logStream.print(heuristic.getName() + ",");
                    logStream.print(fm.countNodes() + ",");
                    logStream.print(realECR + ",");
                    if (r != null) {
                        logStream.print(r.getHeuristicRunningTime() + ",");
                        logStream.print(r.getBDDBuildingTime() + ",");
                        logStream.print(r.getBDD().nodeCount() + ",");
                        logStream.print(r.getBDDFactory().getNodeTableSize() + ",");
                    }
                    logStream.print("\r\n");
                    logStream.flush();
                } else {
                    System.out.println(">> BDD has size 0, sorry!");
                }
            }
            catch (FileNotFoundException exc) {
                exc.printStackTrace();
            }
            if (!genFile) continue;
            ++i;
        }
        logStream.close();
        System.out.println("done!");
    }

    private void saveFeatureModel(FeatureModel fm, FeatureModelStatistics stats, String location) {
        PrintStream stream = null;
        PrintStream standartOut = System.out;
        try {
            stream = new PrintStream(location);
            System.setOut(stream);
            fm.dumpXML();
            System.out.println("<!--");
            stats.dump();
            System.out.println("-->");
            System.setOut(standartOut);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isFMSatisfiable(FeatureModel fm) {
        FMReasoningWithBDD r = null;
        try {
            VariableOrderingHeuristic heuristic = this.getHeuristic("Pre-CL-MinSpan", fm);
            r = new FMReasoningWithBDD(fm, heuristic, this.nodeNum, this.cacheSize, (long)this.timeout, "pre-order");
            r.getBDDFactory().setIncreaseFactor(this.BDDTableIncreaseFactor);
            r.getBDDFactory().setMinFreeNodes(this.BDDGCFactor);
            ((ReasoningWithBDD)r).init();
            if (r.getBDD().nodeCount() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void shrinkOnly() {
        int countFeatures = 0;
        int countECvars = 0;
        for (int i = this.startFromIndexInCollection; i <= this.numberOfFilesToGenerate; ++i) {
            try {
                System.out.println("Shrinking file: " + this.collection + this.collectionSet + "-" + i + ".xml to " + this.collection + this.collectionSet + "-" + i + "_shrunk.xml");
                XMLFeatureModel fm = new XMLFeatureModel(this.mainPath + this.outputPath + "\\" + "\\" + this.collection + this.collectionSet + "-" + i + ".xml");
                fm.loadModel();
                fm.shrink();
                countFeatures += fm.countNodes();
                countECvars += fm.countConstraintsVariables();
                FeatureModelStatistics stats = new FeatureModelStatistics(fm);
                stats.update();
                PrintStream standartOut = System.out;
                PrintStream stream = new PrintStream(this.mainPath + this.outputPath + "\\" + "\\" + this.collection + this.collectionSet + "-" + i + "_shrunk.xml");
                System.setOut(stream);
                fm.dumpXML();
                System.out.println("<!--");
                stats.dump();
                System.out.println("-->");
                System.setOut(standartOut);
                stream.flush();
                stream.close();
                System.out.println("done! ");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println("ECR: " + (float)countECvars / (1.0f * (float)countFeatures));
    }
}

