/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.generator;

import java.io.File;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.sat4j.specs.ContradictionException;
import splar.apps.generator.FMGeneratorEngineListener;
import splar.core.constraints.CNFGenerator;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelStatistics;
import splar.core.fm.randomization.Random3CNFFeatureModel;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;

public class FMGeneratorEngine {
    private List<FMGeneratorEngineListener> listeners;
    CNFGenerator cnfGenerator;
    String collectionName = "undefinedCollectionName";
    int modelSize = 100;
    int ECR = 0;
    int ECRRange = 2;
    int ECR_comp = 0;
    int startIndex = 1;
    int endIndex = 10;
    int genSAT = 1;
    int percVar3cnf = 100;
    int percForm3cnf = 100;
    float clauseDensity = 3.0f;
    String modelPath = "";
    int percentageOptional = 25;
    int percentageMandatory = 25;
    int percentageExclusiveOR = 25;
    int percentageInclusiveOR = 25;
    int minBranchingFactor = 1;
    int maxBranchingFactor = 6;
    int maxGroupSize = 5;
    boolean canceled = false;
    DecimalFormat format2 = new DecimalFormat("0.0");
    DecimalFormat format3 = new DecimalFormat("0.00");

    public FMGeneratorEngine() {
        this.listeners = new LinkedList<FMGeneratorEngineListener>();
    }

    public void addListener(FMGeneratorEngineListener listener) {
        this.listeners.add(listener);
    }

    public void fireEvent(String event, String modelName, String message) {
        for (FMGeneratorEngineListener listener : this.listeners) {
            if (event.equalsIgnoreCase("modelGenerationStarted")) {
                listener.modelGenerationStarted();
                continue;
            }
            if (event.equalsIgnoreCase("modelGenerationEnded")) {
                listener.modelGenerationEnded();
                continue;
            }
            if (event.equalsIgnoreCase("generatingModel")) {
                listener.generatingModel(modelName);
                continue;
            }
            if (event.equalsIgnoreCase("doneGeneratingModel")) {
                listener.doneGeneratingModel(modelName);
                continue;
            }
            if (event.equalsIgnoreCase("modelAccepted")) {
                listener.modelAccepted(modelName);
                continue;
            }
            if (event.equalsIgnoreCase("modelRejected")) {
                listener.modelRejected(modelName, message);
                continue;
            }
            if (event.equalsIgnoreCase("modelIsUnsat")) {
                listener.modelIsUnsat(modelName);
                continue;
            }
            if (event.equalsIgnoreCase("modelIsSat")) {
                listener.modelIsSat(modelName);
                continue;
            }
            if (event.equalsIgnoreCase("errorDuringGeneration")) {
                listener.errorDuringGeneration(modelName, message);
                continue;
            }
            if (!event.equalsIgnoreCase("generationCanceled")) continue;
            listener.generationCanceled();
        }
    }

    private void prepare() {
        if (this.collectionName.trim().isEmpty()) {
            this.collectionName = "undefinedCollectionName";
        }
        this.canceled = false;
        this.cnfGenerator = new CNFGenerator();
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setCollectionPath(String path) {
        this.modelPath = path;
        if (!path.endsWith("\\")) {
            this.modelPath = this.modelPath + "\\";
        }
    }

    public void setCollectionSize(int size) {
        this.startIndex = 1;
        this.endIndex = size;
    }

    public void setFeatureModelSize(int size) {
        this.modelSize = size;
    }

    public void setMandatoryPercentage(int percentage) {
        this.percentageMandatory = percentage;
    }

    public void setOptionalPercentage(int percentage) {
        this.percentageOptional = percentage;
    }

    public void setExclusiveORPercentage(int percentage) {
        this.percentageExclusiveOR = percentage;
    }

    public void setInclusiveORPercentage(int percentage) {
        this.percentageInclusiveOR = percentage;
    }

    public void setMinimumBranchingFactor(int minBranchingFactor) {
        this.minBranchingFactor = minBranchingFactor;
    }

    public void setMaximumBranchingFactor(int maxBranchingFactor) {
        this.maxBranchingFactor = maxBranchingFactor;
    }

    public void setMaximumGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    public void setCTCR(int CTCR) {
        this.ECR = CTCR;
    }

    public void setCTCRTolerance(int CTCRTolerance) {
        this.ECRRange = CTCRTolerance;
    }

    public void setClauseDensity(float clauseDensity) {
        this.clauseDensity = clauseDensity;
    }

    public void setModelConsistency(int consistency) {
        this.genSAT = consistency;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void run() {
        this.fireEvent("modelGenerationStarted", "", "");
        this.prepare();
        FeatureModel fm = null;
        FeatureModelStatistics stats = null;
        int index = this.startIndex;
        while (index <= this.endIndex && !this.canceled) {
            String modelIndex = "#" + index;
            try {
                this.fireEvent("generatingModel", modelIndex, "");
                fm = this.generateFeatureModel(index, this.modelSize, (double)this.ECR / 100.0, this.clauseDensity);
                this.fireEvent("doneGeneratingModel", modelIndex, "");
            }
            catch (Exception e) {
                this.fireEvent("errorDuringGeneration", modelIndex, e.getMessage());
                continue;
            }
            stats = new FeatureModelStatistics(fm);
            stats.update();
            try {
                boolean modelIsSAT = false;
                try {
                    modelIsSAT = this.isSAT(fm);
                }
                catch (ContradictionException ce) {
                    modelIsSAT = false;
                }
                String modelName = this.getModelName(modelIsSAT, index);
                if (this.genSAT == -1) {
                    if (modelIsSAT) {
                        this.fireEvent("modelRejected", modelIndex, "Model is CONSISTENT");
                        this.fireEvent("modelIsSat", modelIndex, "");
                        continue;
                    }
                    this.fireEvent("modelIsUnsat", modelIndex, "");
                } else if (this.genSAT == 1) {
                    if (!modelIsSAT) {
                        this.fireEvent("modelRejected", modelIndex, "Model is INCONSISTENT");
                        this.fireEvent("modelIsUnsat", modelIndex, "");
                        continue;
                    }
                    this.fireEvent("modelIsSat", modelIndex, "");
                }
                fm.setName(modelName);
                this.saveFeatureModel(fm, stats, this.modelPath + modelName + ".xml");
                this.fireEvent("modelAccepted", modelName, "");
                this.fireEvent("doneGeneratingModel", modelName, "");
                ++index;
            }
            catch (Exception e) {
                this.fireEvent("errorDuringGeneration", modelIndex, e.getMessage());
            }
        }
        if (this.canceled) {
            this.fireEvent("generationCanceled", "", "");
        } else {
            this.fireEvent("modelGenerationEnded", "", "");
        }
    }

    private String getModelName(boolean isSAT, int index) {
        return this.collectionName + "-3CNF-FM-" + this.modelSize + "-" + (int)((double)this.ECR / 100.0 * (double)this.modelSize) + "-" + this.format3.format(this.clauseDensity) + "-" + (isSAT ? "SAT-" : "UNSAT-") + index;
    }

    public boolean isSAT(FeatureModel fm) throws Exception {
        FMReasoningWithSAT r = new FMReasoningWithSAT("MiniSAT", fm, 60000);
        long start = System.nanoTime();
        r.init();
        return r.isConsistent();
    }

    private void saveFeatureModel(FeatureModel fm, FeatureModelStatistics stats, String location) {
        File file = new File(location);
        PrintStream stream = null;
        PrintStream standartOut = System.out;
        try {
            stream = new PrintStream(location);
            System.setOut(stream);
            fm.dumpXML();
            System.out.println("<!--");
            stats.dump();
            System.out.println("*************************************************************");
            System.out.println("CROSS-TREE CONSTRAINTS (Random 3-CNF Formula)");
            System.out.println("  CTC Representativeness (CTCR): " + this.format2.format(stats.getECRepresentativeness() * 100.0) + "%");
            System.out.println("  Number of 3-CNF clauses......: " + stats.countConstraints());
            System.out.println("  CTC clause density specified.: " + this.format3.format(this.clauseDensity));
            System.out.println("*************************************************************");
            System.out.println("-->");
            System.setOut(standartOut);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FeatureModel generateFeatureModel(int index, int fmSize, double ECR, double density) throws Exception {
        Random3CNFFeatureModel fm = new Random3CNFFeatureModel("", this.modelSize, this.percentageMandatory, this.percentageOptional, this.percentageInclusiveOR, this.percentageExclusiveOR, this.minBranchingFactor, this.maxBranchingFactor, this.maxGroupSize, 0);
        fm.loadModel();
        fm.createCrossTreeConstraintsAsRandom3CNFFormula((int)(ECR * (double)fmSize), this.clauseDensity);
        return fm;
    }
}

