/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import splar.core.constraints.BooleanVariableInterface;

public class BooleanVariable
implements BooleanVariableInterface {
    private String name;
    private int value;
    private boolean isImmutable;
    private BooleanVariableInterface propagationVar = null;
    private boolean state;
    private Object attachedData;

    public BooleanVariable(String name) {
        this.name = name;
        this.value = -1;
        this.isImmutable = false;
    }

    public BooleanVariable(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean isPositive() {
        return this.state;
    }

    @Override
    public void setImmutable(boolean immutable) {
        this.isImmutable = immutable;
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public void assignValue(int value, BooleanVariableInterface propagationVar) {
        if (!this.isImmutable) {
            this.value = value;
            this.propagationVar = propagationVar;
        }
    }

    @Override
    public boolean isPropagation() {
        return this.propagationVar != null;
    }

    @Override
    public BooleanVariableInterface getPropagationVariable() {
        return this.propagationVar;
    }

    @Override
    public void assignValue(int value) {
        if (!this.isImmutable) {
            this.value = value;
            this.propagationVar = null;
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean isInstantiated() {
        return this.value != -1;
    }

    @Override
    public void resetValue() {
        if (!this.isImmutable) {
            this.value = -1;
        }
    }

    @Override
    public void attachData(Object object) {
        this.attachedData = object;
    }

    @Override
    public Object getAttachedData() {
        return this.attachedData;
    }

    @Override
    public void resetAttachedData() {
        this.attachedData = null;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object var) {
        if (var == null) {
            return false;
        }
        return this.getID().equals(((BooleanVariableInterface)var).getID());
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

