/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints.parsing;

import splar.core.constraints.BooleanVariable;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.parsing.CNFClauseParseException;

public class CNFClauseParser {
    protected int index;
    protected static String negationToken = "~";
    protected static String tokens = negationToken + "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public CNFClause parse(String cnfClause) throws CNFClauseParseException {
        this.index = 0;
        if ((cnfClause = cnfClause.trim()).length() == 0) {
            throw new CNFClauseParseException("Error parsing CNF clause (empty clause not permitted).");
        }
        if (cnfClause.indexOf(")") != -1 || cnfClause.indexOf("(") != -1) {
            throw new CNFClauseParseException("Error parsing CNF clause (do not use paranthesis).");
        }
        CNFClause cnfClauseObj = new CNFClause();
        this.skipBlanks(cnfClause);
        while (!this.EOF(cnfClause)) {
            String literal = this.parseLiteral(cnfClause);
            this.createLiteral(cnfClauseObj, cnfClause, literal);
            this.skipBlanks(cnfClause);
            if (this.EOF(cnfClause)) continue;
            this.parseOR(cnfClause);
            this.skipBlanks(cnfClause);
            if (!this.EOF(cnfClause)) continue;
            throw new CNFClauseParseException("Error parsing CNF clause (a literal is missing after operator 'OR').");
        }
        return cnfClauseObj;
    }

    protected void createLiteral(CNFClause cnfClauseObj, String cnfClause, String literal) throws CNFClauseParseException {
        CNFLiteral cnfLiteralObj = null;
        if (literal.startsWith(negationToken)) {
            if (literal.length() - negationToken.length() == 0) {
                throw new CNFClauseParseException("Error parsing CNF clause '" + cnfClause + "' (a variable name is missing).");
            }
            cnfLiteralObj = new CNFLiteral(new BooleanVariable(literal.substring(negationToken.length())), false);
        } else {
            cnfLiteralObj = new CNFLiteral(new BooleanVariable(literal), true);
        }
        cnfClauseObj.addLiteral(cnfLiteralObj);
    }

    protected boolean parseOR(String cnfClause) throws CNFClauseParseException {
        if (this.currentChar(cnfClause).compareToIgnoreCase("O") == 0) {
            ++this.index;
            if (this.currentChar(cnfClause).compareToIgnoreCase("R") == 0) {
                ++this.index;
                return true;
            }
        }
        return false;
    }

    protected String currentChar(String cnfClause) {
        return cnfClause.substring(this.index, this.index + 1);
    }

    protected String parseLiteral(String cnfClause) throws CNFClauseParseException {
        String literal = "";
        if (this.isValidToken(this.currentChar(cnfClause))) {
            literal = literal + this.currentChar(cnfClause);
            ++this.index;
            while (!this.EOF(cnfClause) && this.isValidToken(this.currentChar(cnfClause))) {
                literal = literal + this.currentChar(cnfClause);
                ++this.index;
            }
        } else {
            throw new CNFClauseParseException("Error parsing CNF clause '" + cnfClause + "' (please use only letter, digits and symbol '_' to name variables - to negate a variable use symbol '" + negationToken + "').");
        }
        return literal;
    }

    protected boolean EOF(String cnfClause) {
        return this.index >= cnfClause.length();
    }

    protected boolean isValidToken(String str) {
        return tokens.indexOf(str) != -1;
    }

    protected void skipBlanks(String cnfClause) {
        if (!this.EOF(cnfClause)) {
            while (this.currentChar(cnfClause).startsWith(" ")) {
                ++this.index;
            }
        }
    }
}

