/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import splar.core.constraints.Assignment;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureModelListener;
import splar.core.fm.FeatureModelState;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.FeatureValueAssignmentException;
import splar.core.fm.GroupedFeature;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.clustering.FTCluster;

public abstract class FeatureModel
extends DefaultTreeModel
implements FeatureModelListener {
    private String name = "";
    private Map<String, String> metadata;
    private FeatureTreeNode root = null;
    protected Map<String, FeatureTreeNode> nodesMap = new LinkedHashMap<String, FeatureTreeNode>();
    private Map<String, PropositionalFormula> constraints = null;
    protected List<FeatureTreeNode> lastPropagatedNodes = null;
    private int countNodes = 0;
    private List<FeatureModelListener> listeners;
    private HashMap<String, FeatureModelState> states;
    private FeatureTreeNode subTreeRootNode = null;

    public FeatureModel() {
        super(null, true);
        this.metadata = new LinkedHashMap<String, String>();
        this.constraints = new LinkedHashMap<String, PropositionalFormula>();
        this.states = new HashMap();
        this.lastPropagatedNodes = new Vector<FeatureTreeNode>();
        this.listeners = new ArrayList<FeatureModelListener>();
    }

    public void addMetaData(String name, String value) {
        this.metadata.put(name, value);
    }

    public String getMetaData(String name) {
        String value = this.metadata.get(name);
        return value == null ? "" : value;
    }

    public Set<String> getMetaDataKeys() {
        return this.metadata.keySet();
    }

    @Override
    public void onInstantiatingFeature(FeatureTreeNode node, boolean value) {
    }

    public void resetInstantiatedNodesCounter() {
    }

    public Set<FeatureTreeNode> getUninstantiatedNodes() {
        HashSet<FeatureTreeNode> nodes = new HashSet<FeatureTreeNode>();
        for (FeatureTreeNode node : this.getNodes()) {
            if (node instanceof FeatureGroup || node.isInstantiated()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public Set<FeatureTreeNode> getInstantiatedNodes() {
        HashSet<FeatureTreeNode> nodes = new HashSet<FeatureTreeNode>();
        for (FeatureTreeNode node : this.getNodes()) {
            if (node instanceof FeatureGroup || !node.isInstantiated()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public void addListener(FeatureModelListener listener) {
        this.listeners.add(listener);
    }

    private void dispatchOnInstantiatingFeatureEvent(FeatureTreeNode node, boolean value) {
        for (FeatureModelListener listener : this.listeners) {
            listener.onInstantiatingFeature(node, value);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FeatureModel getFeatureModelSubTree(FeatureTreeNode node) {
        this.subTreeRootNode = node;
        return new FeatureModel(){

            @Override
            protected FeatureTreeNode createNodes() throws FeatureModelException {
                return new SolitaireFeature(true, FeatureModel.this.subTreeRootNode.getID(), FeatureModel.this.subTreeRootNode.getName(), null);
            }

            @Override
            protected void saveNodes() {
            }
        };
    }

    public void shrink() {
        this.shrink(this.getRoot(), this.getRoot());
    }

    public void shrink(FeatureTreeNode node, FeatureTreeNode startNode) {
        int countChild = node.getChildCount();
        FeatureTreeNode[] childNodes = new FeatureTreeNode[countChild];
        for (int i = 0; i < countChild; ++i) {
            childNodes[countChild - i - 1] = (FeatureTreeNode)node.getChildAt(i);
        }
        if (this.isMandatory(node)) {
            FeatureTreeNode parent = (FeatureTreeNode)node.getParent();
            parent.remove(node);
            for (FeatureTreeNode childNode : childNodes) {
                parent.add(childNode);
            }
            for (PropositionalFormula formula : this.getConstraints()) {
                formula.replaceVariable(node.getID(), parent.getID());
            }
            this.nodesMap.remove(node.getID());
        }
        for (FeatureTreeNode childNode : childNodes) {
            this.shrink(childNode, startNode);
        }
        if (node == startNode) {
            this.countNodes(startNode);
            this.lastPropagatedNodes = new Vector<FeatureTreeNode>();
            this.states.clear();
        }
    }

    public List<FeatureTreeNode> getNodesAtLevel(int level) {
        int curLevel = 0;
        FeatureTreeNode rootNode = this.getRoot();
        ArrayList<FeatureTreeNode> nodes = new ArrayList<FeatureTreeNode>();
        nodes.add(rootNode);
        int levelCounter = 1;
        int nextLevelCounter = 0;
        while (nodes.size() > 0 && curLevel < level) {
            FeatureTreeNode curNode = nodes.get(0);
            if (curLevel < level) {
                nodes.remove(0);
                int count = curNode.getChildCount();
                for (int i = 0; i < count; ++i) {
                    FeatureTreeNode childNode = (FeatureTreeNode)curNode.getChildAt(i);
                    childNode.attachData(new Integer(curLevel + 1));
                    nodes.add(childNode);
                    ++nextLevelCounter;
                }
            }
            if (--levelCounter != 0) continue;
            levelCounter = nextLevelCounter;
            nextLevelCounter = 0;
            ++curLevel;
        }
        return nodes;
    }

    public void getSubtreeNodes(FeatureTreeNode subtreeRootNode, List<FeatureTreeNode> nodes) {
        if (subtreeRootNode != null) {
            int count = subtreeRootNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)subtreeRootNode.getChildAt(i);
                if (!(childNode instanceof FeatureGroup)) {
                    nodes.add(childNode);
                }
                this.getSubtreeNodes(childNode, nodes);
            }
        }
    }

    public int getNodeLevel(String nodeID) {
        FeatureTreeNode node = this.getNodeByID(nodeID);
        if (node != null) {
            int level = 0;
            TreeNode parent = node;
            do {
                if ((parent = parent.getParent()) == null) continue;
                ++level;
            } while (parent != null);
            return level;
        }
        return -1;
    }

    public void resetNodesAttachedData() {
        Vector<FeatureTreeNode> allNodes = new Vector<FeatureTreeNode>();
        this.getAllNodes(this.getRoot(), allNodes);
        for (FeatureTreeNode node : allNodes) {
            node.resetAttachedData();
        }
    }

    public Assignment getInstantiatedVariables() {
        Assignment a = new Assignment();
        for (FeatureTreeNode node : this.getNodes()) {
            if (!node.isInstantiated() || node instanceof FeatureGroup) continue;
            a.add(node);
        }
        return a;
    }

    public PropositionalFormula getConstraintsAsPropositionalFormula() {
        StringBuffer combinedFormulas = new StringBuffer(100);
        Iterator<PropositionalFormula> it = this.constraints.values().iterator();
        while (it.hasNext()) {
            combinedFormulas.append("(" + it.next().getFormula() + ")");
            if (!it.hasNext()) continue;
            combinedFormulas.append(" AND ");
        }
        PropositionalFormula pf = null;
        try {
            pf = new PropositionalFormula("", combinedFormulas.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pf;
    }

    public void saveState(String stateID) {
        FeatureModelState state = new FeatureModelState(stateID, this);
        state.save();
        this.states.put(stateID, state);
    }

    public void restoreState(String stateID) {
        this.restoreState(stateID, true);
    }

    public void restoreState(String stateID, boolean discardState) {
        FeatureModelState state = this.states.get(stateID);
        if (state != null) {
            state.restore();
            if (discardState) {
                this.discardState(stateID);
            }
        }
    }

    public void discardState(String stateID) {
        FeatureModelState state = this.states.get(stateID);
        state.discard();
        this.states.remove(stateID);
    }

    public boolean isExtraConstraintVariable(FeatureTreeNode node) {
        return this.getConstraintsVariablesSet().contains(node);
    }

    public void setValue(String featureID, int value) throws FeatureValueAssignmentException {
        this.assignValue(this.nodesMap.get(featureID), value);
    }

    public void assignValue(FeatureTreeNode node, int value) throws FeatureValueAssignmentException {
        if (node != null) {
            if (!node.isImmutable()) {
                if (value == -1 || node.getValue() == -1) {
                    node.assignValue(value);
                    if (value != -1) {
                        this.dispatchOnInstantiatingFeatureEvent(node, value != 0);
                    }
                } else if (node.getValue() != value) {
                    String nodeName = node.getName();
                    if (node instanceof FeatureGroup) {
                        nodeName = "Feature group of node " + ((FeatureTreeNode)node.getParent()).getName();
                    }
                    throw new FeatureValueAssignmentException("FT assignment conflict: " + nodeName + "(current=" + node.getValue() + "," + "new=" + value + ")");
                }
            } else if (node.getValue() != value) {
                String nodeName = node.getName();
                if (node instanceof FeatureGroup) {
                    nodeName = "Feature group of node " + ((FeatureTreeNode)node.getParent()).getName();
                }
                throw new FeatureValueAssignmentException("FT assignment conflict: " + nodeName + " is IMMUTABLE (current=" + node.getValue() + "," + "new=" + value + ")");
            }
        }
    }

    public void assignValue(FeatureTreeNode node, int value, BooleanVariableInterface propagationVar) throws FeatureValueAssignmentException {
        if (node != null && !node.isImmutable()) {
            node.assignValue(value, propagationVar);
            if (value != -1) {
                this.dispatchOnInstantiatingFeatureEvent(node, value != 0);
            }
        }
    }

    public int getValue(String featureID) {
        FeatureTreeNode node = this.nodesMap.get(featureID);
        if (node != null) {
            return node.getValue();
        }
        return -2;
    }

    public List<FeatureTreeNode> getLastPropagatedNodes() {
        return this.lastPropagatedNodes;
    }

    public static int countGroupedNodes(FeatureGroup featureGroupNode, int valueToCount, Collection<FeatureTreeNode> unassignedGroupedNodes) {
        int countNodes = 0;
        int groupedNodesCount = featureGroupNode.getChildCount();
        for (int i = 0; i < groupedNodesCount; ++i) {
            FeatureTreeNode curGroupedNode = (FeatureTreeNode)featureGroupNode.getChildAt(i);
            int nodeValue = curGroupedNode.getValue();
            if (nodeValue == valueToCount) {
                ++countNodes;
                continue;
            }
            if (nodeValue != -1) continue;
            unassignedGroupedNodes.add(curGroupedNode);
        }
        return countNodes;
    }

    public void loadModel() throws FeatureModelException {
        this.root = this.createNodes();
        this.countNodes(this.root);
    }

    public void saveModel() {
        this.saveNodes();
    }

    public int countNodes() {
        this.countNodes = this.countNodes(this.getRoot());
        return this.countNodes;
    }

    public int countFeatures(boolean instantiated) {
        int counter = 0;
        for (FeatureTreeNode node : this.getNodes()) {
            if (node instanceof FeatureGroup || node.isInstantiated() != instantiated) continue;
            ++counter;
        }
        return counter;
    }

    public int countFeatures() {
        int counter = 0;
        for (FeatureTreeNode node : this.getNodes()) {
            if (node instanceof FeatureGroup) continue;
            ++counter;
        }
        return counter;
    }

    public double getAverageDepth() {
        int sumDepths = 0;
        Collection<FeatureTreeNode> leaves = this.getLeaves();
        for (FeatureTreeNode node : leaves) {
            if (node.getChildCount() != 0) continue;
            sumDepths += this.depth(node);
        }
        return 1.0 * (double)sumDepths / (double)leaves.size();
    }

    public double getDepthStandardDeviation() {
        double squareSum = 0.0;
        Collection<FeatureTreeNode> leaves = this.getLeaves();
        for (FeatureTreeNode node : leaves) {
            if (node.getChildCount() != 0) continue;
            int d = this.depth(node);
            squareSum += (double)(d * d);
        }
        double avgDepth = this.getAverageDepth();
        return Math.sqrt(squareSum / (double)leaves.size() - avgDepth * avgDepth);
    }

    public double getDepthDeviationCoeficient() {
        double squareSum = 0.0;
        Collection<FeatureTreeNode> leaves = this.getLeaves();
        for (FeatureTreeNode node : leaves) {
            if (node.getChildCount() != 0) continue;
            int d = this.depth(node);
            squareSum += (double)(d * d);
        }
        double avgDepth = this.getAverageDepth();
        return Math.sqrt(squareSum / (double)leaves.size() - avgDepth * avgDepth) / avgDepth;
    }

    public int depth(FeatureTreeNode node) {
        int depth = -1;
        if (node != null) {
            depth = 0;
            FeatureTreeNode parent = node;
            FeatureTreeNode featureTreeNode = parent = (parent = (FeatureTreeNode)parent.getParent()) != null && parent instanceof FeatureGroup ? (FeatureTreeNode)parent.getParent() : parent;
            while (parent != null) {
                ++depth;
                parent = (parent = (FeatureTreeNode)parent.getParent()) != null && parent instanceof FeatureGroup ? (FeatureTreeNode)parent.getParent() : parent;
            }
        }
        return depth;
    }

    public int getLevel(FeatureTreeNode node) {
        if (node == this.getRoot()) {
            return 0;
        }
        int level = 0;
        FeatureTreeNode parent = node;
        do {
            ++level;
        } while ((parent = (parent = (FeatureTreeNode)parent.getParent()) instanceof FeatureGroup ? parent.getParent() : parent) != this.getRoot());
        return level;
    }

    public int depthFeatures() {
        return this.depth(this.getRoot(), 0, false);
    }

    public int depth() {
        return this.depth(this.getRoot(), 0, true);
    }

    private int depth(FeatureTreeNode node, int depth, boolean countGroups) {
        if (node == null) {
            return depth;
        }
        int count = node.getChildCount();
        if (count == 0) {
            return depth;
        }
        int maxDepth = depth;
        for (int i = 0; i < count; ++i) {
            int d = 0;
            d = countGroups || !countGroups && !(node instanceof FeatureGroup) ? this.depth((FeatureTreeNode)node.getChildAt(i), depth + 1, countGroups) : this.depth((FeatureTreeNode)node.getChildAt(i), depth, countGroups);
            maxDepth = Math.max(d, maxDepth);
        }
        return maxDepth;
    }

    public void removeAllConstraints() {
        this.constraints.clear();
    }

    public void addConstraint(PropositionalFormula constraint) {
        this.constraints.put(constraint.getName(), constraint);
    }

    public PropositionalFormula getConstraintByName(String name) {
        return this.constraints.get(name);
    }

    public Collection<PropositionalFormula> getConstraints() {
        return this.constraints.values();
    }

    public int countConstraints() {
        return this.constraints.size();
    }

    public int countConstraintsVariables() {
        return this.getConstraintsVariablesSet().size();
    }

    public Set<BooleanVariableInterface> getConstraintsVariablesSet() {
        LinkedHashSet<BooleanVariableInterface> variables = new LinkedHashSet<BooleanVariableInterface>();
        if (this.constraints != null) {
            for (PropositionalFormula c : this.constraints.values()) {
                for (BooleanVariableInterface booleanVariableInterface : c.getVariables()) {
                    variables.add(booleanVariableInterface);
                }
            }
        }
        return variables;
    }

    public Collection<FeatureTreeNode> getNodes() {
        return this.nodesMap.values();
    }

    public List<FeatureTreeNode> getNodes(FeatureTreeNode node) {
        ArrayList<FeatureTreeNode> nodeList = new ArrayList<FeatureTreeNode>();
        this.getNodes(nodeList, node);
        return nodeList;
    }

    private void getNodes(List<FeatureTreeNode> nodeList, FeatureTreeNode node) {
        if (node != null) {
            nodeList.add(node);
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getNodes(nodeList, (FeatureTreeNode)node.getChildAt(i));
            }
        }
    }

    public int countNodes(FeatureTreeNode node) {
        this.countNodes = 0;
        if (node != null) {
            if (!(node instanceof FeatureGroup)) {
                ++this.countNodes;
            }
            this.nodesMap.put(node.getID(), node);
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.countNodes += this.countNodes((FeatureTreeNode)node.getChildAt(i));
            }
        }
        return this.countNodes;
    }

    public Collection<FeatureTreeNode> getLeaves() {
        ArrayList<FeatureTreeNode> leaves = new ArrayList<FeatureTreeNode>();
        for (FeatureTreeNode node : this.getNodes()) {
            if (node.getChildCount() != 0) continue;
            leaves.add(node);
        }
        return leaves;
    }

    public FeatureTreeNode getNodeByID(String nodeName) {
        return this.nodesMap.get(nodeName);
    }

    @Override
    public FeatureTreeNode getRoot() {
        return this.root;
    }

    public boolean isRoot(FeatureTreeNode node) {
        return node.equals(this.getRoot());
    }

    public Collection<FeatureTreeNode> DES(FeatureTreeNode node) {
        return this.descendants(node);
    }

    public Collection<FeatureTreeNode> ANC(FeatureTreeNode node) {
        return this.ancestors(node);
    }

    public Collection<FeatureTreeNode> GSI(FeatureTreeNode node) {
        return this.groupSiblingNodes(node);
    }

    public boolean isMandatory(FeatureTreeNode node) {
        if (node != null && node instanceof SolitaireFeature) {
            SolitaireFeature auxNode = (SolitaireFeature)node;
            return !auxNode.isOptional();
        }
        return false;
    }

    public boolean isOptional(FeatureTreeNode node) {
        if (node != null && node instanceof SolitaireFeature) {
            SolitaireFeature auxNode = (SolitaireFeature)node;
            return auxNode.isOptional();
        }
        return false;
    }

    public boolean isMandatoryTypeOfNode(FeatureTreeNode node) {
        try {
            boolean isMandatoryTypeOfNode = false;
            if (node != null) {
                if (node instanceof SolitaireFeature) {
                    SolitaireFeature auxNode = (SolitaireFeature)node;
                    isMandatoryTypeOfNode = !auxNode.isOptional();
                } else if (node instanceof GroupedFeature) {
                    GroupedFeature auxNode = (GroupedFeature)node;
                    isMandatoryTypeOfNode = ((FeatureGroup)auxNode.getParent()).getMin() > 0;
                }
            }
            return isMandatoryTypeOfNode;
        }
        catch (Exception e) {
            System.out.println("A grouped feature's parent must be a FeatureGroup. Please check node '" + node + "' and its parent.");
            return false;
        }
    }

    private boolean isQualifiedNode(FeatureTreeNode node, FeatureTreeNode baseNode) {
        return node != baseNode;
    }

    public Collection<FeatureTreeNode> descendants(Collection<FeatureTreeNode> nodes) {
        Vector<FeatureTreeNode> descendantNodes = new Vector<FeatureTreeNode>();
        if (nodes != null) {
            Iterator<FeatureTreeNode> it = nodes.iterator();
            while (it.hasNext()) {
                Collection<FeatureTreeNode> result = this.descendants(it.next());
                if (result == null) continue;
                descendantNodes.addAll(result);
            }
        }
        return descendantNodes;
    }

    public Collection<FeatureTreeNode> descendants(FeatureTreeNode node) {
        Vector<FeatureTreeNode> descNodes = new Vector<FeatureTreeNode>();
        this.descendants(node, descNodes);
        descNodes.remove(node);
        return descNodes;
    }

    private void descendants(FeatureTreeNode node, Collection<FeatureTreeNode> descNodes) {
        if (node != null) {
            int count;
            if (!(node instanceof FeatureGroup)) {
                descNodes.add(node);
            }
            if ((count = node.getChildCount()) > 0) {
                for (int i = 0; i < count; ++i) {
                    FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                    this.descendants(childNode, descNodes);
                }
            }
        }
    }

    public Collection<FeatureTreeNode> ancestors(Collection<FeatureTreeNode> nodes) {
        Vector<FeatureTreeNode> ancestorNodes = new Vector<FeatureTreeNode>();
        if (nodes != null) {
            Iterator<FeatureTreeNode> it = nodes.iterator();
            while (it.hasNext()) {
                Collection<FeatureTreeNode> result = this.ancestors(it.next());
                if (result == null) continue;
                ancestorNodes.addAll(result);
            }
        }
        return ancestorNodes;
    }

    public Collection<FeatureTreeNode> ancestors(FeatureTreeNode node) {
        Vector<FeatureTreeNode> ancNodes = new Vector<FeatureTreeNode>();
        this.ancestors(node, ancNodes);
        ancNodes.remove(node);
        return ancNodes;
    }

    private void ancestors(FeatureTreeNode node, Collection<FeatureTreeNode> ancNodes) {
        if (node != null && node != this.getRoot()) {
            FeatureTreeNode parent;
            if (!(node instanceof FeatureGroup)) {
                ancNodes.add(node);
            }
            if ((parent = (FeatureTreeNode)node.getParent()) != null) {
                this.ancestors(parent, ancNodes);
            }
        }
    }

    public Collection<FeatureTreeNode> groupSiblingNodes(Collection<FeatureTreeNode> nodes) {
        Vector<FeatureTreeNode> gsnNodes = new Vector<FeatureTreeNode>();
        if (nodes != null) {
            Iterator<FeatureTreeNode> it = nodes.iterator();
            while (it.hasNext()) {
                Collection<FeatureTreeNode> result = this.groupSiblingNodes(it.next());
                if (result == null) continue;
                gsnNodes.addAll(result);
            }
        }
        return gsnNodes;
    }

    public Collection<FeatureTreeNode> groupSiblingNodes(FeatureTreeNode node) {
        Vector<FeatureTreeNode> gNodes = new Vector<FeatureTreeNode>();
        if (node instanceof GroupedFeature) {
            FeatureGroup parent = (FeatureGroup)node.getParent();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                FeatureTreeNode chNode = (FeatureTreeNode)parent.getChildAt(i);
                if (chNode == node) continue;
                gNodes.add(chNode);
            }
        }
        return gNodes;
    }

    public Iterator<FeatureTreeNode> nodesIterator() {
        Vector<FeatureTreeNode> allNodes = new Vector<FeatureTreeNode>();
        this.getAllNodes(this.getRoot(), allNodes);
        return allNodes.iterator();
    }

    private void getAllNodes(FeatureTreeNode node, Collection<FeatureTreeNode> allNodes) {
        if (node != null) {
            allNodes.add(node);
            int count = node.getChildCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.getAllNodes((FeatureTreeNode)node.getChildAt(i), allNodes);
                }
            }
        }
    }

    public CNFFormula EC2CNF() {
        if (this.countConstraints() == 0) {
            return null;
        }
        CNFFormula cnf = new CNFFormula();
        for (PropositionalFormula pf : this.getConstraints()) {
            cnf.addClauses(pf.toCNFClauses());
        }
        return cnf;
    }

    public CNFFormula FT2CNF() {
        CNFFormula cnf = new CNFFormula();
        Vector<FeatureTreeNode> nodes = new Vector<FeatureTreeNode>();
        nodes.add(this.getRoot());
        CNFClause rootClause = new CNFClause();
        rootClause.addLiteral(new CNFLiteral(new BooleanVariable(this.getRoot().getID()), true));
        cnf.addClause(rootClause);
        while (nodes.size() > 0) {
            FeatureTreeNode node = (FeatureTreeNode)nodes.firstElement();
            nodes.remove(node);
            if (node == null) continue;
            FeatureTreeNode parent = (FeatureTreeNode)node.getParent();
            if (node instanceof FeatureGroup) {
                FeatureTreeNode groupedNode;
                int i;
                parent = (FeatureTreeNode)node.getParent();
                int min = ((FeatureGroup)node).getMin();
                int max = ((FeatureGroup)node).getMax();
                int childCount = node.getChildCount();
                CNFClause clause1 = new CNFClause();
                FeatureTreeNode[] groupedNodes = new FeatureTreeNode[childCount];
                clause1.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), false));
                for (i = 0; i < childCount; ++i) {
                    groupedNodes[i] = groupedNode = (FeatureTreeNode)node.getChildAt(i);
                    clause1.addLiteral(new CNFLiteral(new BooleanVariable(groupedNode.getID()), true));
                    CNFClause clause2 = new CNFClause();
                    clause2.addLiteral(new CNFLiteral(new BooleanVariable(groupedNode.getID()), false));
                    clause2.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), true));
                    cnf.addClause(clause2);
                }
                cnf.addClause(clause1);
                if (min == 1 && max == 1) {
                    this.addExclusiveOrGroupClauses(cnf, groupedNodes, null, 0, 0, 2);
                }
                for (i = 0; i < node.getChildCount(); ++i) {
                    groupedNode = (FeatureTreeNode)node.getChildAt(i);
                    for (int j = 0; j < groupedNode.getChildCount(); ++j) {
                        nodes.add((FeatureTreeNode)groupedNode.getChildAt(j));
                    }
                }
                continue;
            }
            if (parent != null) {
                CNFClause clause = new CNFClause();
                clause.addLiteral(new CNFLiteral(new BooleanVariable(node.getID()), false));
                clause.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), true));
                cnf.addClause(clause);
                if (!((SolitaireFeature)node).isOptional()) {
                    clause = new CNFClause();
                    clause.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), false));
                    clause.addLiteral(new CNFLiteral(new BooleanVariable(node.getID()), true));
                    cnf.addClause(clause);
                }
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.add((FeatureTreeNode)node.getChildAt(i));
            }
        }
        return cnf;
    }

    public CNFFormula FT2CNFSkipAssignedVariables() {
        CNFFormula cnf = new CNFFormula();
        Vector<FeatureTreeNode> nodes = new Vector<FeatureTreeNode>();
        nodes.add(this.getRoot());
        while (nodes.size() > 0) {
            FeatureTreeNode node = (FeatureTreeNode)nodes.firstElement();
            nodes.remove(node);
            if (node == null) continue;
            FeatureTreeNode parent = (FeatureTreeNode)node.getParent();
            if (node instanceof FeatureGroup) {
                FeatureTreeNode groupedNode;
                int i;
                parent = (FeatureTreeNode)node.getParent();
                int min = ((FeatureGroup)node).getMin();
                int max = ((FeatureGroup)node).getMax();
                Vector<FeatureTreeNode> unassignedGroupedNodes = new Vector<FeatureTreeNode>();
                for (i = 0; i < node.getChildCount(); ++i) {
                    groupedNode = (FeatureTreeNode)node.getChildAt(i);
                    if (groupedNode.isInstantiated()) continue;
                    unassignedGroupedNodes.add(groupedNode);
                }
                if (unassignedGroupedNodes.size() > 0) {
                    CNFClause clause1 = new CNFClause();
                    if (!parent.isInstantiated()) {
                        clause1.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), false));
                    }
                    for (FeatureTreeNode groupedNode2 : unassignedGroupedNodes) {
                        clause1.addLiteral(new CNFLiteral(new BooleanVariable(groupedNode2.getID()), true));
                        if (parent.isInstantiated()) continue;
                        CNFClause clause2 = new CNFClause();
                        clause2.addLiteral(new CNFLiteral(new BooleanVariable(groupedNode2.getID()), false));
                        clause2.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), true));
                        cnf.addClause(clause2);
                    }
                    cnf.addClause(clause1);
                    if (min == 1 && max == 1) {
                        this.addExclusiveOrGroupClauses(cnf, unassignedGroupedNodes.toArray(new FeatureTreeNode[0]), null, 0, 0, 2);
                    }
                }
                for (i = 0; i < node.getChildCount(); ++i) {
                    groupedNode = (FeatureTreeNode)node.getChildAt(i);
                    if (groupedNode.getValue() != 1 && groupedNode.isInstantiated()) continue;
                    for (int j = 0; j < groupedNode.getChildCount(); ++j) {
                        nodes.add((FeatureTreeNode)groupedNode.getChildAt(j));
                    }
                }
                continue;
            }
            if (node instanceof SolitaireFeature && !node.isInstantiated() && !parent.isInstantiated()) {
                CNFClause clause = new CNFClause();
                clause.addLiteral(new CNFLiteral(new BooleanVariable(node.getID()), false));
                clause.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), true));
                cnf.addClause(clause);
                if (!((SolitaireFeature)node).isOptional()) {
                    clause = new CNFClause();
                    clause.addLiteral(new CNFLiteral(new BooleanVariable(parent.getID()), false));
                    clause.addLiteral(new CNFLiteral(new BooleanVariable(node.getID()), true));
                    cnf.addClause(clause);
                }
            }
            if (node.isInstantiated() && node.getValue() != 1) continue;
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.add((FeatureTreeNode)node.getChildAt(i));
            }
        }
        return cnf;
    }

    private void addExclusiveOrGroupClauses(CNFFormula cnf, FeatureTreeNode[] group, int[] index, int level, int start, int p) {
        int i;
        if (index == null) {
            index = new int[p];
            for (i = 0; i < index.length; ++i) {
                index[i] = -1;
            }
        }
        if (level == p) {
            CNFClause clause = new CNFClause();
            for (int i2 = 0; i2 < index.length; ++i2) {
                clause.addLiteral(new CNFLiteral(group[index[i2]], false));
            }
            cnf.addClause(clause);
        } else {
            for (i = start; i < group.length; ++i) {
                index[level] = i;
                this.addExclusiveOrGroupClauses(cnf, group, index, level + 1, i + 1, p);
            }
        }
    }

    public CNFFormula FM2CNF() {
        CNFFormula cnf = new CNFFormula();
        cnf.addClauses(this.FT2CNF().getClauses());
        if (this.countConstraints() > 0) {
            cnf.addClauses(this.EC2CNF().getClauses());
        }
        return cnf;
    }

    public Map<String, FTCluster> generateFTClusterDependencyView() {
        LinkedHashMap<String, FTCluster> view = new LinkedHashMap<String, FTCluster>();
        FeatureTreeNode ftRootNode = this.getRoot();
        FTCluster ftRootCluster = new FTCluster(ftRootNode);
        view.put(ftRootNode.getID(), ftRootCluster);
        HashSet<FeatureTreeNode> flatNodesSet = new HashSet<FeatureTreeNode>();
        for (FeatureTreeNode child : ftRootCluster.getChildren()) {
            flatNodesSet.add(child);
        }
        for (PropositionalFormula pf : this.getConstraints()) {
            for (CNFClause cnfClause : pf.toCNFClauses()) {
                ArrayList<FeatureTreeNode> identifiedNodes = new ArrayList<FeatureTreeNode>();
                FeatureTreeNode clusterRootNode = this.identifyViewNodes(cnfClause, identifiedNodes);
                if (identifiedNodes.size() <= 1) continue;
                FTCluster cluster = (FTCluster)view.get(clusterRootNode.getID());
                if (cluster == null) {
                    cluster = new FTCluster(clusterRootNode);
                    view.put(clusterRootNode.getID(), cluster);
                }
                cluster.addRelation(identifiedNodes, cnfClause.getVariables());
                for (FeatureTreeNode child : cluster.getChildren()) {
                    flatNodesSet.add(child);
                }
            }
        }
        for (String clusterName : view.keySet()) {
            FTCluster cluster = (FTCluster)view.get(clusterName);
            FeatureTreeNode ancestor = FeatureModel.findNearestAncestorOnList(cluster.getRoot(), flatNodesSet);
            if (ancestor == null) continue;
            cluster.setAncestor(ancestor);
        }
        return view;
    }

    private static FeatureTreeNode findNearestAncestorOnList(FeatureTreeNode node, Set<FeatureTreeNode> list) {
        if (node != null) {
            FeatureTreeNode ancestor = node;
            do {
                if (!list.contains(ancestor)) continue;
                return ancestor;
            } while ((ancestor = (FeatureTreeNode)ancestor.getParent()) != null);
        }
        return null;
    }

    public FeatureTreeNode lowestCommonAncestor(List<FeatureTreeNode> nodes) {
        boolean bl;
        int index;
        Vector ancestorsList = new Vector();
        for (FeatureTreeNode node : nodes) {
            ArrayList<FeatureTreeNode> arrayList = new ArrayList<FeatureTreeNode>();
            if (node == null) continue;
            arrayList.add(0, node);
            for (FeatureTreeNode ancestorNode = (FeatureTreeNode)node.getParent(); ancestorNode != null; ancestorNode = (FeatureTreeNode)ancestorNode.getParent()) {
                arrayList.add(0, ancestorNode);
            }
            ancestorsList.add(arrayList);
        }
        int minSize = Integer.MAX_VALUE;
        for (List list : ancestorsList) {
            int listSize = list.size();
            if (listSize >= minSize) continue;
            minSize = listSize;
        }
        FeatureTreeNode commonAncestor = null;
        boolean bl2 = false;
        for (index = 0; index < minSize && !bl; ++index) {
            FeatureTreeNode ancestorNode = null;
            for (List list : ancestorsList) {
                FeatureTreeNode tempNode = (FeatureTreeNode)list.get(index);
                if (ancestorNode == null) {
                    ancestorNode = tempNode;
                    continue;
                }
                if (tempNode == ancestorNode) continue;
                bl = true;
            }
            if (bl) continue;
            commonAncestor = ancestorNode;
        }
        LinkedHashSet variables = new LinkedHashSet();
        for (List list : ancestorsList) {
            if (list.size() < index) continue;
            variables.add(list.get(index - 1));
        }
        nodes.addAll(variables);
        return commonAncestor;
    }

    public boolean isAncestor(FeatureTreeNode possibleAncestor, FeatureTreeNode node) {
        for (FeatureTreeNode curNode = node; curNode != null; curNode = (FeatureTreeNode)curNode.getParent()) {
            if (curNode != possibleAncestor) continue;
            return true;
        }
        return false;
    }

    private FeatureTreeNode identifyViewNodes(CNFClause clause, List<FeatureTreeNode> nodes) {
        boolean bl;
        int index;
        FeatureTreeNode ancestorNode;
        Vector ancestorsList = new Vector();
        for (BooleanVariableInterface var : clause.getVariables()) {
            ArrayList<FeatureTreeNode> arrayList = new ArrayList<FeatureTreeNode>();
            FeatureTreeNode node = this.getNodeByID(var.getID());
            if (node == null) continue;
            arrayList.add(0, node);
            for (ancestorNode = (FeatureTreeNode)node.getParent(); ancestorNode != null; ancestorNode = (FeatureTreeNode)ancestorNode.getParent()) {
                arrayList.add(0, ancestorNode);
            }
            ancestorsList.add(arrayList);
        }
        int minSize = Integer.MAX_VALUE;
        for (List list : ancestorsList) {
            int listSize = list.size();
            if (listSize >= minSize) continue;
            minSize = listSize;
        }
        FeatureTreeNode commonAncestor = null;
        boolean bl2 = false;
        for (index = 0; index < minSize && !bl; ++index) {
            ancestorNode = null;
            for (List list : ancestorsList) {
                FeatureTreeNode tempNode = (FeatureTreeNode)list.get(index);
                if (ancestorNode == null) {
                    ancestorNode = tempNode;
                    continue;
                }
                if (tempNode == ancestorNode) continue;
                bl = true;
            }
            if (bl) continue;
            commonAncestor = ancestorNode;
        }
        LinkedHashSet variables = new LinkedHashSet();
        for (List list : ancestorsList) {
            if (list.size() < index) continue;
            variables.add(list.get(index - 1));
        }
        nodes.addAll(variables);
        return commonAncestor;
    }

    public void dumpValues() {
        this.dump(this.getRoot(), 0, 3, true);
        this.dumpConstraints();
    }

    public void dump() {
        this.dump(this.getRoot(), 0, 3, false);
        this.dumpConstraints();
    }

    public void dumpConstraints() {
        for (PropositionalFormula c : this.getConstraints()) {
            System.out.println(c);
        }
    }

    public void dumpConstraintsXML() {
        for (PropositionalFormula c : this.getConstraints()) {
            System.out.println(c.getName() + ":" + c.toString());
        }
    }

    public void dump(FeatureTreeNode node, int level, int space, boolean values) {
        if (node != null) {
            for (int i = 1; i <= level * space; ++i) {
                System.out.print(" ");
            }
            String value = values ? " = " + node.getValue() : "";
            System.out.println(node + value);
            int count = node.getChildCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.dump((FeatureTreeNode)node.getChildAt(i), level + 1, space, values);
                }
            }
        }
    }

    public void dumpMetaData() {
        System.out.println("<meta>");
        for (String name : this.metadata.keySet()) {
            System.out.println("<data name=\"" + name + "\">" + this.metadata.get(name) + "</data>");
        }
        System.out.println("</meta>");
    }

    public void dumpXML() {
        System.out.println("<feature_model name=\"" + this.getName() + "\">");
        this.dumpMetaData();
        System.out.println("<feature_tree>");
        this.dumpTabs(this.getRoot(), 0);
        System.out.println("</feature_tree>");
        System.out.println("<constraints>");
        this.dumpConstraintsXML();
        System.out.println("</constraints>");
        System.out.println("</feature_model>");
    }

    public void dumpTabs(FeatureTreeNode node, int level) {
        if (node != null) {
            for (int i = 1; i <= level; ++i) {
                System.out.print("\t");
            }
            System.out.println(node);
            int count = node.getChildCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.dumpTabs((FeatureTreeNode)node.getChildAt(i), level + 1);
                }
            }
        }
    }

    protected abstract FeatureTreeNode createNodes() throws FeatureModelException;

    protected abstract void saveNodes();
}

