/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.util.List;
import java.util.Vector;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;

class FeatureModelState {
    private String stateID;
    private FeatureModel featureModel;
    private List<FeatureTreeNode> lastPropagatedNodes = null;

    public FeatureModelState(String stateID, FeatureModel featureModel) {
        this.stateID = stateID;
        this.featureModel = featureModel;
    }

    public String getStateID() {
        return this.stateID;
    }

    public void save() {
        this.lastPropagatedNodes = new Vector<FeatureTreeNode>();
        this.lastPropagatedNodes.addAll(this.featureModel.lastPropagatedNodes);
        for (FeatureTreeNode featureNode : this.featureModel.getNodes()) {
            featureNode.saveState(this.stateID);
        }
    }

    public void restore() {
        for (FeatureTreeNode featureNode : this.featureModel.getNodes()) {
            featureNode.restoreState(this.stateID, false);
        }
        this.featureModel.lastPropagatedNodes.clear();
        this.featureModel.lastPropagatedNodes.addAll(this.lastPropagatedNodes);
    }

    public void discard() {
        for (FeatureTreeNode featureNode : this.featureModel.getNodes()) {
            featureNode.discardState(this.stateID);
        }
    }
}

