/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.util.Arrays;
import java.util.Iterator;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;

public class FeatureModelStatistics {
    private FeatureModel fm;
    int root = 0;
    int opt = 0;
    int man = 0;
    int grp11 = 0;
    int grp1n = 0;
    int fgrp11 = 0;
    int fgrp1n = 0;

    public FeatureModelStatistics(FeatureModel fm) {
        this.fm = fm;
    }

    public FeatureModel getFeatureModel() {
        return this.fm;
    }

    public void reset() {
        this.root = 0;
        this.opt = 0;
        this.man = 0;
        this.grp11 = 0;
        this.grp1n = 0;
        this.fgrp11 = 0;
        this.fgrp1n = 0;
    }

    public void update() {
        this.reset();
        Iterator<FeatureTreeNode> it = this.fm.nodesIterator();
        while (it.hasNext()) {
            int max;
            int min;
            FeatureGroup fg;
            FeatureTreeNode node = it.next();
            if (node instanceof RootNode) {
                ++this.root;
                continue;
            }
            if (node instanceof SolitaireFeature) {
                if (((SolitaireFeature)node).isOptional()) {
                    ++this.opt;
                    continue;
                }
                ++this.man;
                continue;
            }
            if (node instanceof GroupedFeature) {
                fg = (FeatureGroup)node.getParent();
                min = fg.getMin();
                if (min == (max = fg.getMax()) && min == 1) {
                    ++this.grp11;
                    continue;
                }
                if (min != 1 || max != -1 && max != fg.getChildCount()) continue;
                ++this.grp1n;
                continue;
            }
            if (!(node instanceof FeatureGroup)) continue;
            fg = (FeatureGroup)node;
            min = fg.getMin();
            if (min == (max = fg.getMax()) && min == 1) {
                ++this.fgrp11;
                continue;
            }
            if (min != 1 || max != -1 && max != fg.getChildCount()) continue;
            ++this.fgrp1n;
        }
    }

    public int countNodes() {
        return this.fm.countNodes();
    }

    public int countFeatures() {
        return this.root + this.opt + this.man + this.grp11 + this.grp1n;
    }

    public int depth() {
        return this.fm.depth();
    }

    public int countMandatory() {
        return this.man;
    }

    public int countOptional() {
        return this.opt;
    }

    public int countGrouped() {
        return this.grp11 + this.grp1n;
    }

    public int countGrouped11() {
        return this.grp11;
    }

    public int countGrouped1n() {
        return this.grp1n;
    }

    public int countGroups11() {
        return this.fgrp11;
    }

    public int countGroups1N() {
        return this.fgrp1n;
    }

    public int countConstraints() {
        return this.fm.countConstraints();
    }

    public int countConstraintVars() {
        return this.fm.countConstraintsVariables();
    }

    public double getAverageDepth() {
        return this.fm.getAverageDepth();
    }

    public double getDepthStandardDeviation() {
        return this.fm.getDepthStandardDeviation();
    }

    public double getDepthDeviationCoeficient() {
        return this.fm.getDepthDeviationCoeficient();
    }

    public int countFeatureModelCNFClauses() {
        return this.fm.FM2CNF().countClauses();
    }

    public int countFeatureTreeCNFClauses() {
        return this.fm.FT2CNF().countClauses();
    }

    public int countExtraConstraintCNFClauses() {
        return this.fm.EC2CNF().countClauses();
    }

    public int[] count23NClauses() {
        int[] clauseSizeCounter = new int[3];
        Arrays.fill(clauseSizeCounter, 0);
        for (CNFClause clause : this.fm.FM2CNF().getClauses()) {
            int numVars = clause.countVariables();
            if (numVars == 2) {
                clauseSizeCounter[0] = clauseSizeCounter[0] + 1;
                continue;
            }
            if (numVars == 3) {
                clauseSizeCounter[1] = clauseSizeCounter[1] + 1;
                continue;
            }
            clauseSizeCounter[2] = clauseSizeCounter[2] + 1;
        }
        return clauseSizeCounter;
    }

    public double getECClauseDensity() {
        CNFFormula cnf = this.fm.EC2CNF();
        return cnf == null ? 0.0 : cnf.getClauseDensity();
    }

    public double getECRepresentativeness() {
        return (double)this.fm.countConstraintsVariables() / (1.0 * (double)this.fm.countFeatures());
    }

    public long countDecisions() {
        return this.fm.getInstantiatedNodes().size();
    }

    public int countInstantiatedNodes() {
        return this.fm.getInstantiatedNodes().size();
    }

    public int countUninstantiatedNodes() {
        return this.fm.countNodes() - this.fm.getInstantiatedNodes().size();
    }

    public String toString() {
        StringBuffer str = new StringBuffer(100);
        str.append("*************************************************************");
        str.append("\r\nFEATURE TREE STATISTICS");
        str.append("\r\n");
        str.append("  Model name.: " + this.fm.getName());
        str.append("\r\n");
        str.append("  tree depth.: ");
        str.append(this.fm.depth());
        str.append("\r\n");
        str.append("  #root......: ");
        str.append(this.root);
        str.append("\r\n");
        str.append("  #opt.......: ");
        str.append(this.opt);
        str.append("\r\n");
        str.append("  #man.......: ");
        str.append(this.man);
        str.append("\r\n");
        str.append("  #grouped...: ");
        str.append(this.grp11 + this.grp1n);
        str.append("\r\n");
        str.append("  #grouped [1,1]: ");
        str.append(this.grp11);
        str.append("\r\n");
        str.append("  #grouped [1,n]: ");
        str.append(this.grp1n);
        str.append("\r\n");
        str.append("  #fgrp [1,1]: ");
        str.append(this.fgrp11);
        str.append(" (exclusive-OR)\r\n");
        str.append("  #fgrp [1,N]: ");
        str.append(this.fgrp1n);
        str.append(" (inclusive-OR)\r\n");
        str.append("  #total features: ");
        str.append(this.countFeatures());
        str.append("\r\n");
        str.append("  #total nodes: ");
        str.append(this.root + this.opt + this.man + this.grp11 + this.grp1n + this.fgrp11 + this.fgrp1n);
        String formula = "";
        int countConstraints = 0;
        Iterator<PropositionalFormula> it = this.fm.getConstraints().iterator();
        while (it.hasNext()) {
            PropositionalFormula pf = it.next();
            formula = formula + "(" + pf.getFormula() + ")";
            if (it.hasNext()) {
                formula = formula + " AND ";
            }
            ++countConstraints;
        }
        return str.toString();
    }

    public void dump() {
        System.out.println(this.toString());
    }
}

