/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.clustering;

import java.util.ArrayList;
import java.util.List;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.fm.FeatureTreeNode;

public class FTCluster {
    private FeatureTreeNode ancestor;
    private FeatureTreeNode root;
    private List<List<FeatureTreeNode>> clusterNodesRelations;
    private List<List<BooleanVariableInterface>> clauseNodesRelations;

    public FTCluster(FeatureTreeNode root) {
        this.root = root;
        this.ancestor = null;
        this.clusterNodesRelations = new ArrayList<List<FeatureTreeNode>>();
        this.clauseNodesRelations = new ArrayList<List<BooleanVariableInterface>>();
    }

    public FeatureTreeNode getRoot() {
        return this.root;
    }

    public void setAncestor(FeatureTreeNode ancestor) {
        this.ancestor = ancestor;
    }

    public FeatureTreeNode getAncestor() {
        return this.ancestor;
    }

    public List<FeatureTreeNode> getChildren() {
        ArrayList<FeatureTreeNode> children = new ArrayList<FeatureTreeNode>();
        int count = this.root.getChildCount();
        for (int i = 0; i < count; ++i) {
            children.add((FeatureTreeNode)this.root.getChildAt(i));
        }
        return children;
    }

    public void addRelation(List<FeatureTreeNode> clusterNodesRelation, List<BooleanVariableInterface> clauseNodesRelation) {
        this.clusterNodesRelations.add(clusterNodesRelation);
        this.clauseNodesRelations.add(clauseNodesRelation);
    }

    public List<List<FeatureTreeNode>> getClusterNodesRelations() {
        return this.clusterNodesRelations;
    }

    public List<List<BooleanVariableInterface>> getClauseNodesRelations() {
        return this.clauseNodesRelations;
    }
}

